/*
 * Decompiled with CFR 0.152.
 */
package com.nameme.bukkit;

import com.nameme.bukkit.command.CommandNameMe;
import com.nameme.bukkit.util.NameMeConfig;
import com.nameme.shared.ConfigCache;
import com.nameme.shared.PlayerCache;
import java.io.File;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NameMe
extends JavaPlugin {
    public NameMeConfig config;
    public ConfigCache cc;

    public void onEnable() {
        this.createConfig();
        this.registerCommands();
        this.config = new NameMeConfig(this.getConfig());
        this.cc = new ConfigCache(this.config);
        this.startCacheService();
    }

    public void onDisable() {
    }

    private void createConfig() {
        try {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                this.getLogger().info("config.yml not found, creating!");
                this.saveDefaultConfig();
            } else {
                this.getLogger().info("config.yml found, loading!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerCommands() {
        this.getCommand("name").setExecutor((CommandExecutor)new CommandNameMe());
    }

    public void startCacheService() {
        if (this.cc.isCacheEnabled()) {
            Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    PlayerCache.getInstance().getCacheList().clear();
                    if (NameMe.this.cc.isDebug()) {
                        NameMe.this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "Clearing NameMe cache!");
                    }
                }
            }, 0L, 1200L * (long)this.cc.getCacheRetention());
        }
    }
}

