/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.listeners;

import net.jitse.npclib.NPCLib;
import net.jitse.npclib.internal.NPCBase;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.listeners.HandleMoveBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerListener
extends HandleMoveBase
implements Listener {
    private final NPCLib instance;

    public PlayerListener(NPCLib instance) {
        this.instance = instance;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        for (NPCBase npc : NPCManager.getAllNPCs()) {
            npc.onLogout(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        for (NPCBase npc : NPCManager.getAllNPCs()) {
            if (!npc.isShown(player) || !npc.getWorld().equals(player.getWorld())) continue;
            npc.hide(player, true);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        final Location respawn = event.getRespawnLocation();
        if (respawn.getWorld() != null && respawn.getWorld().equals(player.getWorld())) {
            new BukkitRunnable(){

                public void run() {
                    if (!player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    if (player.getLocation().equals((Object)respawn)) {
                        PlayerListener.this.handleMove(player);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.instance.getPlugin(), 0L, 1L);
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World from = event.getFrom();
        for (NPCBase npc : NPCManager.getAllNPCs()) {
            if (!npc.isShown(player) || !npc.getWorld().equals(from)) continue;
            npc.hide(player, true);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.handleMove(event.getPlayer());
    }
}

