/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.listeners;

import java.util.HashMap;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.listeners.HandleMoveBase;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PeriodicMoveListener
extends HandleMoveBase
implements Listener {
    private final NPCLib instance;
    private final long updateInterval;
    private final HashMap<UUID, BukkitTask> tasks = new HashMap();

    public PeriodicMoveListener(NPCLib instance, long updateInterval) {
        this.instance = instance;
        this.updateInterval = updateInterval;
    }

    private void startTask(UUID uuid) {
        this.tasks.put(uuid, Bukkit.getScheduler().runTaskTimer((Plugin)this.instance.getPlugin(), () -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                this.handleMove(player);
            }
        }, 1L, this.updateInterval));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.startTask(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BukkitTask task = this.tasks.remove(event.getPlayer().getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }
}

