/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.internal;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.NPC;
import net.jitse.npclib.api.events.NPCHideEvent;
import net.jitse.npclib.api.events.NPCShowEvent;
import net.jitse.npclib.api.skin.Skin;
import net.jitse.npclib.api.state.NPCAnimation;
import net.jitse.npclib.api.state.NPCSlot;
import net.jitse.npclib.api.state.NPCState;
import net.jitse.npclib.hologram.Hologram;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.internal.NPCPacketHandler;
import net.jitse.npclib.utilities.MathUtil;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class NPCBase
implements NPC,
NPCPacketHandler {
    protected final int entityId = Integer.MAX_VALUE - NPCManager.getAllNPCs().size();
    protected final Set<UUID> hasTeamRegistered = new HashSet<UUID>();
    protected final Set<NPCState> activeStates = EnumSet.noneOf(NPCState.class);
    private final Set<UUID> shown = new HashSet<UUID>();
    private final Set<UUID> autoHidden = new HashSet<UUID>();
    protected double cosFOV = Math.cos(Math.toRadians(60.0));
    protected UUID uuid = new UUID(new Random().nextLong(), 0L);
    protected String name = this.uuid.toString().replace("-", "").substring(0, 10);
    protected GameProfile gameProfile = new GameProfile(this.uuid, this.name);
    protected boolean created = false;
    protected NPCLib instance;
    protected List<String> text;
    protected Location location;
    protected Skin skin;
    protected final Map<NPCSlot, ItemStack> items = new EnumMap<NPCSlot, ItemStack>(NPCSlot.class);
    protected final Map<UUID, List<String>> uniqueText = new HashMap<UUID, List<String>>();
    protected final Map<UUID, Hologram> textDisplayHolograms = new HashMap<UUID, Hologram>();

    public NPCBase(NPCLib instance, List<String> text) {
        this.instance = instance;
        this.text = text == null ? Collections.emptyList() : text;
        NPCManager.add(this);
    }

    public NPCLib getInstance() {
        return this.instance;
    }

    @Override
    public Hologram getPlayerHologram(Player player) {
        Validate.notNull((Object)player, (String)"Player cannot be null.");
        Hologram playerHologram = this.textDisplayHolograms.getOrDefault(player.getUniqueId(), null);
        return playerHologram;
    }

    @Override
    public NPC removePlayerLines(Player targetPlayer) {
        Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
        this.setPlayerLines(null, targetPlayer);
        return this;
    }

    @Override
    public NPC removePlayerLines(Player targetPlayer, boolean update) {
        Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
        this.setPlayerLines(null, targetPlayer, update);
        return this;
    }

    @Override
    public NPC setPlayerLines(List<String> uniqueLines, Player targetPlayer) {
        Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
        if (uniqueLines == null) {
            this.uniqueText.remove(targetPlayer.getUniqueId());
        } else {
            this.uniqueText.put(targetPlayer.getUniqueId(), uniqueLines);
        }
        return this;
    }

    @Override
    public NPC setPlayerLines(List<String> uniqueLines, Player targetPlayer, boolean update) {
        Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
        List<String> originalLines = this.getPlayerLines(targetPlayer);
        this.setPlayerLines(uniqueLines, targetPlayer);
        if (update) {
            uniqueLines = this.getPlayerLines(targetPlayer);
            if (originalLines.size() != uniqueLines.size()) {
                Hologram originalhologram = this.getPlayerHologram(targetPlayer);
                originalhologram.hide(targetPlayer);
                this.textDisplayHolograms.remove(targetPlayer.getUniqueId());
            }
            if (this.isShown(targetPlayer)) {
                Hologram hologram = this.getPlayerHologram(targetPlayer);
                List<Object> updatePackets = hologram.getUpdatePackets(this.getPlayerLines(targetPlayer));
                hologram.update(targetPlayer, updatePackets);
            }
        }
        return this;
    }

    @Override
    public List<String> getPlayerLines(Player targetPlayer) {
        Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
        return this.uniqueText.getOrDefault(targetPlayer.getUniqueId(), this.text);
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public NPC setSkin(Skin skin) {
        this.skin = skin;
        this.gameProfile.getProperties().get((Object)"textures").clear();
        if (skin != null) {
            this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return this;
    }

    @Override
    public void destroy() {
        NPCManager.remove(this);
        for (UUID uuid : this.shown) {
            Player plyr;
            if (this.autoHidden.contains(uuid) || (plyr = Bukkit.getPlayer((UUID)uuid)) == null) continue;
            this.getPlayerHologram(plyr).hide(plyr);
            this.hide(plyr, true);
        }
    }

    public void disableFOV() {
        this.cosFOV = 0.0;
    }

    public void setFOV(double fov) {
        this.cosFOV = Math.cos(Math.toRadians(fov));
    }

    public Set<UUID> getShown() {
        return this.shown;
    }

    public Set<UUID> getAutoHidden() {
        return this.autoHidden;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public World getWorld() {
        return this.location != null ? this.location.getWorld() : null;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean isShown(Player player) {
        Objects.requireNonNull(player, "Player object cannot be null");
        return this.shown.contains(player.getUniqueId()) && !this.autoHidden.contains(player.getUniqueId());
    }

    @Override
    public NPC setLocation(Location location) {
        this.location = location;
        return this;
    }

    @Override
    public NPC create() {
        this.createPackets();
        this.created = true;
        return this;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    public void onLogout(Player player) {
        this.getAutoHidden().remove(player.getUniqueId());
        this.getShown().remove(player.getUniqueId());
        this.hasTeamRegistered.remove(player.getUniqueId());
    }

    public boolean inRangeOf(Player player) {
        if (player == null) {
            return false;
        }
        if (!player.getWorld().equals(this.location.getWorld())) {
            return false;
        }
        double hideDistance = this.instance.getAutoHideDistance();
        double distanceSquared = player.getLocation().distanceSquared(this.location);
        double bukkitRange = Bukkit.getViewDistance() << 4;
        return distanceSquared <= MathUtil.square(hideDistance) && distanceSquared <= MathUtil.square(bukkitRange);
    }

    public boolean inViewOf(Player player) {
        Vector dir = this.location.toVector().subtract(player.getEyeLocation().toVector()).normalize();
        return dir.dot(player.getEyeLocation().getDirection()) >= this.cosFOV;
    }

    @Override
    public void show(Player player) {
        this.show(player, false);
    }

    public void show(Player player, boolean auto) {
        NPCShowEvent event = new NPCShowEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.isShown(player)) {
            throw new IllegalArgumentException("NPC is already shown to player");
        }
        if (auto) {
            this.sendShowPackets(player);
            this.sendMetadataPacket(player);
            this.sendEquipmentPackets(player);
            this.autoHidden.remove(player.getUniqueId());
        } else {
            this.shown.add(player.getUniqueId());
            if (this.inRangeOf(player) && this.inViewOf(player)) {
                this.sendShowPackets(player);
                this.sendMetadataPacket(player);
                this.sendEquipmentPackets(player);
            } else {
                this.autoHidden.add(player.getUniqueId());
            }
        }
    }

    @Override
    public void hide(Player player) {
        this.hide(player, false);
    }

    public void hide(Player player, boolean auto) {
        NPCHideEvent event = new NPCHideEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!this.shown.contains(player.getUniqueId())) {
            throw new IllegalArgumentException("NPC cannot be hidden from player before calling NPC#show first");
        }
        if (auto) {
            if (this.autoHidden.contains(player.getUniqueId())) {
                throw new IllegalStateException("NPC cannot be auto-hidden twice");
            }
            this.sendHidePackets(player);
            this.autoHidden.add(player.getUniqueId());
        } else {
            this.shown.remove(player.getUniqueId());
            if (this.inRangeOf(player)) {
                this.sendHidePackets(player);
            } else {
                this.autoHidden.remove(player.getUniqueId());
            }
        }
    }

    @Override
    public boolean getState(NPCState state) {
        return this.activeStates.contains((Object)state);
    }

    @Override
    public NPC toggleState(NPCState state) {
        if (this.activeStates.contains((Object)state)) {
            this.activeStates.remove((Object)state);
        } else {
            this.activeStates.add(state);
        }
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.sendMetadataPacket(player);
        }
        return this;
    }

    @Override
    public void playAnimation(NPCAnimation animation) {
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.sendAnimationPacket(player, animation);
        }
    }

    @Override
    public ItemStack getItem(NPCSlot slot) {
        Objects.requireNonNull(slot, "Slot cannot be null");
        return this.items.get((Object)slot);
    }

    @Override
    public NPC setItem(NPCSlot slot, ItemStack item) {
        Objects.requireNonNull(slot, "Slot cannot be null");
        this.items.put(slot, item);
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.sendEquipmentPacket(player, slot, false);
        }
        return this;
    }

    @Override
    public NPC setText(List<String> text) {
        this.uniqueText.clear();
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            Hologram originalHologram = this.getPlayerHologram(player);
            originalHologram.hide(player);
            this.textDisplayHolograms.remove(player.getUniqueId());
            Hologram hologram = this.getPlayerHologram(player);
            List<Object> updatePackets = hologram.getUpdatePackets(this.getPlayerLines(player));
            hologram.update(player, updatePackets);
        }
        this.text = text;
        return this;
    }

    @Override
    public List<String> getText() {
        return this.text;
    }

    @Override
    public void lookAt(Location location) {
        this.sendHeadRotationPackets(location);
    }
}

