/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.hologram;

import com.comphenix.tinyprotocol.Reflection;
import java.util.ArrayList;
import java.util.List;
import net.jitse.npclib.internal.MinecraftVersion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;

public class Hologram {
    private static final double DELTA = 0.3;
    private static final Class<?> CHAT_COMPONENT_TEXT_CLASS = Reflection.getMinecraftClass("ChatComponentText");
    private static final Class<?> CHAT_BASE_COMPONENT_CLASS = Reflection.getMinecraftClass("IChatBaseComponent");
    private static final Class<?> ENTITY_ARMOR_STAND_CLASS = Reflection.getMinecraftClass("EntityArmorStand");
    private static final Class<?> ENTITY_LIVING_CLASS = Reflection.getMinecraftClass("EntityLiving");
    private static final Class<?> ENTITY_CLASS = Reflection.getMinecraftClass("Entity");
    private static final Class<?> CRAFT_WORLD_CLASS = Reflection.getCraftBukkitClass("CraftWorld");
    private static final Class<?> CRAFT_PLAYER_CLASS = Reflection.getCraftBukkitClass("entity.CraftPlayer");
    private static final Class<?> BUKKIT_ENTITY_ARMOR_STAND_CLASS = Reflection.getClass("org.bukkit.entity.ArmorStand");
    private static final Class<?> PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLASS = Reflection.getMinecraftClass("PacketPlayOutSpawnEntityLiving");
    private static final Class<?> PACKET_PLAY_OUT_ENTITY_DESTROY_CLASS = Reflection.getMinecraftClass("PacketPlayOutEntityDestroy");
    private static final Class<?> PACKET_PLAY_OUT_ENTITY_METADATA_CLASS = Reflection.getMinecraftClass("PacketPlayOutEntityMetadata");
    private static final Class<?> DATAWATCHER_CLASS = Reflection.getMinecraftClass("DataWatcher");
    private static final Class<?> ENTITY_PLAYER_CLASS = Reflection.getMinecraftClass("EntityPlayer");
    private static final Class<?> PLAYER_CONNECTION_CLASS = Reflection.getMinecraftClass("PlayerConnection");
    private static final Class<?> PACKET_CLASS = Reflection.getMinecraftClass("Packet");
    private static final Reflection.ConstructorInvoker CHAT_COMPONENT_TEXT_CONSTRUCTOR = Reflection.getConstructor(CHAT_COMPONENT_TEXT_CLASS, String.class);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLASS, ENTITY_LIVING_CLASS);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_ENTITY_DESTROY_CLASS, int[].class);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_ENTITY_METADATA_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_ENTITY_METADATA_CLASS, Integer.TYPE, DATAWATCHER_CLASS, Boolean.TYPE);
    private static final Reflection.FieldAccessor<?> PLAYER_CONNECTION_FIELD = Reflection.getField(ENTITY_PLAYER_CLASS, "playerConnection", PLAYER_CONNECTION_CLASS);
    private static final Reflection.MethodInvoker SET_LOCATION_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
    private static final Reflection.MethodInvoker SET_SMALL_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setSmall", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_INVISIBLE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setInvisible", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_BASE_PLATE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setBasePlate", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_ARMS_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setArms", Boolean.TYPE);
    private static final Reflection.MethodInvoker GET_BUKKIT_ENTITY = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "getBukkitEntity", new Class[0]);
    private static final Reflection.MethodInvoker PLAYER_GET_HANDLE_METHOD = Reflection.getMethod(CRAFT_PLAYER_CLASS, "getHandle", new Class[0]);
    private static final Reflection.MethodInvoker SEND_PACKET_METHOD = Reflection.getMethod(PLAYER_CONNECTION_CLASS, "sendPacket", PACKET_CLASS);
    private static final Reflection.MethodInvoker GET_ID_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "getId", new Class[0]);
    private static final Reflection.MethodInvoker GET_DATAWATCHER_METHOD = Reflection.getMethod(ENTITY_CLASS, "getDataWatcher", new Class[0]);
    private final List<Object> armorStands = new ArrayList<Object>();
    private final List<Object> showPackets = new ArrayList<Object>();
    private final List<Object> hidePackets = new ArrayList<Object>();
    private final List<Object> metaPackets = new ArrayList<Object>();
    private final MinecraftVersion version;
    private final Location start;
    private final Object worldServer;
    private List<String> text;

    public Hologram(MinecraftVersion version, Location location, List<String> text) {
        this.version = version;
        this.start = location;
        this.text = text;
        this.worldServer = Reflection.getMethod(CRAFT_WORLD_CLASS, "getHandle", new Class[0]).invoke(location.getWorld(), new Object[0]);
        this.createPackets();
    }

    private void createPackets() {
        Reflection.MethodInvoker gravityMethod = this.version.isAboveOrEqual(MinecraftVersion.V1_10_R1) ? Reflection.getMethod(ENTITY_CLASS, "setNoGravity", Boolean.TYPE) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLASS, "setGravity", Boolean.TYPE);
        Reflection.MethodInvoker SET_MARKER_METHOD = this.version.isAboveOrEqual(MinecraftVersion.V1_8_R3) ? Reflection.getMethod(BUKKIT_ENTITY_ARMOR_STAND_CLASS, "setMarker", Boolean.TYPE) : null;
        Reflection.MethodInvoker customNameMethod = Reflection.getMethod(ENTITY_CLASS, "setCustomName", this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_BASE_COMPONENT_CLASS : String.class);
        Reflection.MethodInvoker customNameVisibilityMethod = Reflection.getMethod(ENTITY_CLASS, "setCustomNameVisible", Boolean.TYPE);
        Location location = this.start.clone().add(0.0, 0.3 * (double)this.text.size() + (double)(SET_MARKER_METHOD != null ? 1.0f : 0.0f), 0.0);
        Class<?> worldClass = this.worldServer.getClass().getSuperclass();
        if (this.start.getWorld().getEnvironment() != World.Environment.NORMAL) {
            worldClass = worldClass.getSuperclass();
        }
        Reflection.ConstructorInvoker entityArmorStandConstructor = null;
        try {
            entityArmorStandConstructor = this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? Reflection.getConstructor(ENTITY_ARMOR_STAND_CLASS, worldClass, Double.TYPE, Double.TYPE, Double.TYPE) : Reflection.getConstructor(ENTITY_ARMOR_STAND_CLASS, worldClass);
        }
        catch (IllegalStateException exception) {
            worldClass = worldClass.getSuperclass();
            entityArmorStandConstructor = this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? Reflection.getConstructor(ENTITY_ARMOR_STAND_CLASS, worldClass, Double.TYPE, Double.TYPE, Double.TYPE) : Reflection.getConstructor(ENTITY_ARMOR_STAND_CLASS, worldClass);
        }
        for (String line : this.text) {
            Object entityArmorStand;
            Object object = entityArmorStand = this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? entityArmorStandConstructor.invoke(this.worldServer, location.getX(), location.getY(), location.getZ()) : entityArmorStandConstructor.invoke(this.worldServer);
            if (!this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1)) {
                SET_LOCATION_METHOD.invoke(entityArmorStand, location.getX(), location.getY(), location.getZ(), 0, 0);
            }
            customNameMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_COMPONENT_TEXT_CONSTRUCTOR.invoke(line) : line);
            customNameVisibilityMethod.invoke(entityArmorStand, true);
            gravityMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_9_R2));
            SET_SMALL_METHOD.invoke(entityArmorStand, true);
            SET_INVISIBLE_METHOD.invoke(entityArmorStand, true);
            SET_BASE_PLATE_METHOD.invoke(entityArmorStand, false);
            SET_ARMS_METHOD.invoke(entityArmorStand, false);
            if (SET_MARKER_METHOD != null) {
                Object bukkitEntity = GET_BUKKIT_ENTITY.invoke(entityArmorStand, new Object[0]);
                ArmorStand as = (ArmorStand)bukkitEntity;
                as.setMarker(true);
            }
            this.armorStands.add(entityArmorStand);
            this.showPackets.add(PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR.invoke(entityArmorStand));
            this.hidePackets.add(PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR.invoke(new Object[]{new int[]{(Integer)GET_ID_METHOD.invoke(entityArmorStand, new Object[0])}}));
            this.metaPackets.add(PACKET_PLAY_OUT_ENTITY_METADATA_CONSTRUCTOR.invoke(GET_ID_METHOD.invoke(entityArmorStand, new Object[0]), GET_DATAWATCHER_METHOD.invoke(entityArmorStand, new Object[0]), true));
            location.subtract(0.0, 0.3, 0.0);
        }
    }

    public List<Object> getUpdatePackets(List<String> text) {
        ArrayList<Object> updatePackets = new ArrayList<Object>();
        if (this.text.size() != text.size()) {
            throw new IllegalArgumentException("When updating the text, the old and new text should have the same amount of lines");
        }
        Reflection.MethodInvoker customNameMethod = Reflection.getMethod(ENTITY_CLASS, "setCustomName", this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_BASE_COMPONENT_CLASS : String.class);
        for (int i = 0; i < text.size(); ++i) {
            Object entityArmorStand = this.armorStands.get(i);
            String oldLine = this.text.get(i);
            String newLine = text.get(i);
            customNameMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_COMPONENT_TEXT_CONSTRUCTOR.invoke(newLine) : newLine);
            this.showPackets.set(i, PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR.invoke(entityArmorStand));
            if (newLine.isEmpty() && !oldLine.isEmpty()) {
                updatePackets.add(this.hidePackets.get(i));
                continue;
            }
            if (!newLine.isEmpty() && oldLine.isEmpty()) {
                updatePackets.add(this.showPackets.get(i));
                continue;
            }
            if (oldLine.equals(newLine)) continue;
            updatePackets.add(PACKET_PLAY_OUT_ENTITY_METADATA_CONSTRUCTOR.invoke(GET_ID_METHOD.invoke(entityArmorStand, new Object[0]), GET_DATAWATCHER_METHOD.invoke(entityArmorStand, new Object[0]), true));
        }
        this.text = text;
        return updatePackets;
    }

    public void update(Player player, List<Object> updatePackets) {
        Object playerConnection = PLAYER_CONNECTION_FIELD.get(PLAYER_GET_HANDLE_METHOD.invoke(player, new Object[0]));
        for (Object packet : updatePackets) {
            SEND_PACKET_METHOD.invoke(playerConnection, packet);
        }
    }

    public void show(Player player) {
        Object playerConnection = PLAYER_CONNECTION_FIELD.get(PLAYER_GET_HANDLE_METHOD.invoke(player, new Object[0]));
        for (int i = 0; i < this.text.size(); ++i) {
            if (this.text.get(i).isEmpty()) continue;
            SEND_PACKET_METHOD.invoke(playerConnection, this.showPackets.get(i));
            if (!this.version.isAboveOrEqual(MinecraftVersion.V1_15_R1)) continue;
            SEND_PACKET_METHOD.invoke(playerConnection, this.metaPackets.get(i));
        }
    }

    public void hide(Player player) {
        Object playerConnection = PLAYER_CONNECTION_FIELD.get(PLAYER_GET_HANDLE_METHOD.invoke(player, new Object[0]));
        for (int i = 0; i < this.text.size(); ++i) {
            if (this.text.get(i).isEmpty()) continue;
            SEND_PACKET_METHOD.invoke(playerConnection, this.hidePackets.get(i));
        }
    }
}

