/*
 * Decompiled with CFR 0.152.
 */
package de.npc.utils;

import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Items {
    public ItemStack item(Material type, String name) {
        ItemStack item = new ItemStack(type);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack skull(Material type, String name, String SkullOwner) {
        ItemStack itemStack = new ItemStack(type, 1);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwner(SkullOwner);
        meta.setDisplayName(name);
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public ItemStack Enchantment(ItemStack item, Enchantment enchantment, int level, boolean flags) {
        ItemMeta meta = item.getItemMeta();
        if (flags) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        item.setItemMeta(meta);
        item.addUnsafeEnchantment(enchantment, level);
        return item;
    }

    public ItemStack ChangeName(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack RemoveEnchantment(ItemStack item) {
        for (Enchantment e : item.getEnchantments().keySet()) {
            item.removeEnchantment(e);
        }
        return item;
    }

    public ItemStack RemoveColor(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String display = meta.getDisplayName();
        for (ChatColor color : ChatColor.values()) {
            if (!display.contains(color.toString())) continue;
            display = display.replaceAll(color.toString(), "");
        }
        meta.setDisplayName(display);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack AddFormat(ItemStack item, ChatColor format) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.hasColor(meta.getDisplayName()) + "" + format + meta.getDisplayName().replace(meta.getDisplayName().substring(0, 2), ""));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack RemoveFormat(ItemStack item, ChatColor format) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(meta.getDisplayName().replaceAll(format.toString(), ""));
        item.setItemMeta(meta);
        return item;
    }

    public ChatColor hasColor(String s) {
        for (ChatColor color : ChatColor.values()) {
            if (!s.contains(color.toString())) continue;
            return color;
        }
        return null;
    }

    public ItemStack RemoveFormats(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String display = meta.getDisplayName();
        try {
            display = display.replaceAll(ChatColor.BOLD.toString(), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            display = display.replaceAll(ChatColor.ITALIC.toString(), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            display = display.replaceAll(ChatColor.UNDERLINE.toString(), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            display = display.replaceAll(ChatColor.STRIKETHROUGH.toString(), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        meta.setDisplayName(display);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack Lore(Material type, String name, List<String> lore) {
        ItemStack item = new ItemStack(type);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack Lore(Material type, List<String> lore) {
        ItemStack item = new ItemStack(type);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack Lore(ItemStack item, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack setLore(ItemStack item, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return item;
    }
}

