/*
 * Decompiled with CFR 0.152.
 */
package de.npc.npc;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.npc.Main;
import de.npc.npc.Error;
import de.npc.utils.Action;
import de.npc.utils.PlayerAction;
import de.npc.utils.Prefix;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class NewNPC
implements TabExecutor {
    public static List<EntityPlayer> NPCs = new ArrayList<EntityPlayer>();
    public static HashMap<String, Boolean> edit = new HashMap();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender.isOp() || sender.hasPermission(command.getPermission())) {
            switch (args[0]) {
                case "edit": {
                    if (args.length != 1) {
                        sender.sendMessage(this.Error(Error.EDIT));
                        return true;
                    }
                    String uuid = ((Player)sender).getUniqueId().toString();
                    if (edit == null) {
                        edit = new HashMap();
                    }
                    if (edit.containsKey(uuid)) {
                        if (!edit.get(uuid).booleanValue()) {
                            edit.put(uuid, true);
                            sender.sendMessage(Prefix.server + org.bukkit.ChatColor.GREEN + "Editmode activated");
                            break;
                        }
                        edit.put(uuid, false);
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.RED + "Editmode deactivated");
                        break;
                    }
                    edit.put(uuid, true);
                    sender.sendMessage(Prefix.server + org.bukkit.ChatColor.GREEN + "Editmode activated");
                    break;
                }
                case "create": {
                    if (args.length != 4) {
                        sender.sendMessage(this.Error(Error.CREATE));
                        return true;
                    }
                    try {
                        ChatColor chatColor = ChatColor.valueOf((String)args[3].toUpperCase());
                    }
                    catch (Exception e) {
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.RED + "Wrong color");
                        return true;
                    }
                    String name = args[2];
                    try {
                        name = args[2].replaceAll("@", " ");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (name.length() > 16) {
                        sender.sendMessage(Prefix.server + "The Name is too long");
                        return true;
                    }
                    try {
                        NewNPC.CreateNPC((Player)sender, args[1], name, args[3]);
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.GREEN + "NPC created");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sender.sendMessage(Prefix.error);
                    }
                    break;
                }
                case "delete": {
                    if (args.length != 2) {
                        sender.sendMessage(this.Error(Error.DELETE));
                        return true;
                    }
                    if (!NewNPC.getNPCs().contains(NewNPC.getNPC(args[1]))) {
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.RED + "This NPC does not exist");
                        return true;
                    }
                    File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    config.set("data." + NewNPC.getNumberOfNpc(NewNPC.getNPC(args[1])), null);
                    if (NewNPC.deleteNPC(args[1])) {
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.GREEN + "NPC deleted");
                        NPCs.remove(NewNPC.getNPC(args[1]));
                        try {
                            config.save(file);
                        }
                        catch (IOException iOException) {}
                    } else {
                        sender.sendMessage(Prefix.server + org.bukkit.ChatColor.RED + "NPC could not be deleted");
                    }
                    return true;
                }
                case "list": {
                    sender.sendMessage(ChatColor.GREEN + "NPC's:\n" + ChatColor.GOLD + this.getNPCNames());
                    break;
                }
                default: {
                    sender.sendMessage(this.Error(Error.ALL));
                    return true;
                }
            }
        } else {
            sender.sendMessage(Prefix.noPerm);
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender.isOp() || sender.hasPermission(command.getPermission())) {
            ArrayList<String> list = new ArrayList<String>();
            if (args.length == 1) {
                list.add("create");
                list.add("delete");
                list.add("list");
                list.add("edit");
            } else if (args.length == 2 && args[0].equals("create")) {
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    list.add(player.getName());
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (list.contains(player.getName())) continue;
                    list.add(player.getName());
                }
            } else if (args.length == 4 && args[0].equals("create")) {
                for (ChatColor color : ChatColor.values()) {
                    list.add(color.name().toLowerCase());
                }
            } else if (args.length == 2 && args[0].equals("delete")) {
                return this.getNPCNames();
            }
            return list;
        }
        return new ArrayList<String>();
    }

    private String Error(Error error) {
        switch (error) {
            case ALL: {
                return Prefix.server + ChatColor.RED + "/npc <list | create | delete | edit>";
            }
            case DELETE: {
                return Prefix.server + ChatColor.RED + "/npc delete <name>";
            }
            case CREATE: {
                return Prefix.server + ChatColor.RED + "/npc create <player> <name> <color>";
            }
            case EDIT: {
                return Prefix.server + ChatColor.RED + "/npc edit";
            }
        }
        return Prefix.error;
    }

    public static void CreateNPC(Player player, String npc, String name, String color) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), ChatColor.valueOf((String)color.toUpperCase()) + name);
        EntityPlayer NPC = new EntityPlayer((MinecraftServer)server, world, gameProfile);
        NPC.getBukkitEntity().setAI(false);
        Player npcplayer = NPC.getBukkitEntity().getPlayer();
        npcplayer.setPlayerListName(" ");
        NPC.setLocation(player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ(), player.getLocation().getYaw(), player.getLocation().getPitch());
        String[] skin = NewNPC.getSkin(player, npc);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
        NewNPC.addNPCPacket(NPC);
        NPCs.add(NPC);
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int i = 1;
        if (config.contains("data")) {
            int x = 0;
            for (EntityPlayer npc2 : NewNPC.getNPCs()) {
                if (NewNPC.getNumberOfNpc(npc2) + 1 <= x) continue;
                x = NewNPC.getNumberOfNpc(npc2) + 1;
            }
            i = x;
        }
        player.sendMessage(Prefix.server + ChatColor.GREEN + "ID of the NPC: " + ChatColor.GOLD + i);
        config.set("data." + i + ".world", (Object)player.getWorld().getName());
        config.set("data." + i + ".x", (Object)player.getLocation().getX());
        config.set("data." + i + ".y", (Object)player.getLocation().getY());
        config.set("data." + i + ".z", (Object)player.getLocation().getZ());
        config.set("data." + i + ".pitch", (Object)Float.valueOf(player.getLocation().getPitch()));
        config.set("data." + i + ".yaw", (Object)Float.valueOf(player.getLocation().getYaw()));
        config.set("data." + i + ".name", (Object)(ChatColor.valueOf((String)color.toUpperCase()) + name));
        config.set("data." + i + ".text", (Object)skin[0]);
        config.set("data." + i + ".signature", (Object)skin[1]);
        try {
            config.save(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadNPC(Location location, GameProfile profile) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        EntityPlayer NPC = new EntityPlayer((MinecraftServer)server, world, profile);
        Player npcplayer = NPC.getBukkitEntity().getPlayer();
        npcplayer.setPlayerListName(" ");
        NPC.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        NewNPC.addNPCPacket(NPC);
        NPCs.add(NPC);
    }

    public static void RemoveNPC(Player player, EntityPlayer npc) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
        connection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{npc.getId()}));
        connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{npc}));
        npc.getBukkitEntity().remove();
    }

    public static void addNPCPacket(final EntityPlayer npc) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equals(npc.getWorld().getWorld().getName())) continue;
            final PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
            connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{npc.getBukkitEntity().getHandle()}));
            connection.sendPacket((Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)npc.getBukkitEntity().getHandle()));
            connection.sendPacket((Packet)new PacketPlayOutEntityHeadRotation((Entity)npc.getBukkitEntity().getHandle(), (byte)(npc.getYRot() * 256.0f / 360.0f)));
            new BukkitRunnable(){

                public void run() {
                    connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{npc.getBukkitEntity().getHandle()}));
                }
            }.runTaskLater(Main.plugin, 50L);
        }
    }

    public static void addJoinPacket(Player player) {
        for (final EntityPlayer npc : NPCs) {
            if (!player.getWorld().getName().equals(npc.getWorld().getWorld().getName())) continue;
            final PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
            connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{npc.getBukkitEntity().getHandle()}));
            connection.sendPacket((Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)npc.getBukkitEntity().getHandle()));
            connection.sendPacket((Packet)new PacketPlayOutEntityHeadRotation((Entity)npc.getBukkitEntity().getHandle(), (byte)(npc.getYRot() * 256.0f / 360.0f)));
            new BukkitRunnable(){

                public void run() {
                    connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{npc.getBukkitEntity().getHandle()}));
                }
            }.runTaskLater(Main.plugin, 50L);
        }
    }

    private static String[] getSkin(Player player, String skin) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + skin);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            String uuid = new JsonParser().parse((Reader)reader).getAsJsonObject().get("id").getAsString();
            URL url2 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            InputStreamReader reader2 = new InputStreamReader(url2.openStream());
            JsonObject property = new JsonParser().parse((Reader)reader2).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String texture = property.get("value").getAsString();
            String signature = property.get("signature").getAsString();
            return new String[]{texture, signature};
        }
        catch (Exception e) {
            EntityPlayer p = ((CraftPlayer)player).getHandle();
            GameProfile profile = p.getProfile();
            Property property = (Property)profile.getProperties().get((Object)"textures").iterator().next();
            String texture = property.getValue();
            String signature = property.getSignature();
            return new String[]{texture, signature};
        }
    }

    public static List<EntityPlayer> getNPCs() {
        return NPCs;
    }

    public static boolean deleteNPC(String name) {
        String npc = name.replaceAll("@", " ");
        for (EntityPlayer player : NPCs) {
            if (!player.getName().contains(npc)) continue;
            NPCs.remove(player);
            for (Player p : Bukkit.getOnlinePlayers()) {
                NewNPC.RemoveNPC(p, player);
            }
            return true;
        }
        return false;
    }

    private ArrayList<String> getNPCNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (EntityPlayer player : NPCs) {
            list.add(NewNPC.RemoveColor(player.getName()).replaceAll(" ", "@"));
        }
        return list;
    }

    public static String RemoveColor(String s) {
        for (ChatColor color : ChatColor.values()) {
            if (!s.contains(color.toString())) continue;
            s = s.replace(color.toString(), "");
        }
        return s;
    }

    public static void setNPCs(List<EntityPlayer> NPCList) {
        NPCs = NPCList;
    }

    public static EntityPlayer getNPC(String name) {
        String npc;
        try {
            npc = name.replaceAll("@", " ");
        }
        catch (Exception e) {
            npc = name;
        }
        for (EntityPlayer player : NPCs) {
            if (!player.getName().contains(npc)) continue;
            return player;
        }
        return null;
    }

    public static int getNumberOfNpc(EntityPlayer npc) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String key : config.getKeys(true)) {
            if (!key.contains("name") || !config.getString(key).contains(npc.getName())) continue;
            return Integer.parseInt(key.substring(key.indexOf(".") + 1, key.lastIndexOf(".")));
        }
        return 0;
    }

    public static void setInterAction(EntityPlayer npc, Action action) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("data." + NewNPC.getNumberOfNpc(npc) + ".interaction", (Object)action.name());
        try {
            config.save(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAction(EntityPlayer npc, PlayerAction action) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("data." + NewNPC.getNumberOfNpc(npc) + ".action", (Object)action.name());
        try {
            config.save(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFunction(EntityPlayer npc, String object) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("data." + NewNPC.getNumberOfNpc(npc) + ".function", (Object)object);
        try {
            config.save(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Action getInterAction(EntityPlayer npc) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return Action.valueOf(config.getString("data." + NewNPC.getNumberOfNpc(npc) + ".interaction"));
    }

    public static PlayerAction getAction(EntityPlayer npc) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return PlayerAction.valueOf(config.getString("data." + NewNPC.getNumberOfNpc(npc) + ".action"));
    }

    public static String getFunction(EntityPlayer npc) {
        File file = new File(Main.plugin.getDataFolder(), "NPC.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return config.getString("data." + NewNPC.getNumberOfNpc(npc) + ".function");
    }
}

