/*
 * Decompiled with CFR 0.152.
 */
package de.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.npc.npc.NPC_Click;
import de.npc.npc.NewNPC;
import de.npc.npc.PacketReader;
import de.npc.npc.listener.InventoryClick;
import de.npc.npc.listener.SignEvent;
import java.io.File;
import java.util.UUID;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin
implements Listener {
    public static Plugin plugin;

    public void onEnable() {
        plugin = this;
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.CommandRegistration();
        this.ListenerRegistration();
        this.loadNPC();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.inject(player);
            if (!(NewNPC.getNPCs() != null & !NewNPC.getNPCs().isEmpty())) continue;
            NewNPC.addJoinPacket(player);
        }
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.uninject(player);
            for (EntityPlayer npc : NewNPC.getNPCs()) {
                NewNPC.RemoveNPC(player, npc);
            }
        }
    }

    private void CommandRegistration() {
        this.getCommand("npc").setExecutor((CommandExecutor)new NewNPC());
        this.getCommand("npc").setTabCompleter((TabCompleter)new NewNPC());
    }

    private void ListenerRegistration() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        pluginManager.registerEvents((Listener)new NPC_Click(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryClick(), (Plugin)this);
        pluginManager.registerEvents((Listener)new SignEvent(), (Plugin)this);
    }

    @EventHandler
    public void join(PlayerJoinEvent event) {
        this.inject(event.getPlayer());
        if (NewNPC.getNPCs() != null & !NewNPC.getNPCs().isEmpty()) {
            NewNPC.addJoinPacket(event.getPlayer());
        }
    }

    @EventHandler
    public void Leave(PlayerQuitEvent event) {
        this.uninject(event.getPlayer());
    }

    public void uninject(Player player) {
        PacketReader reader = new PacketReader();
        try {
            reader.uninject(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void inject(Player player) {
        PacketReader reader = new PacketReader();
        try {
            reader.inject(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void ChangeWorld(PlayerChangedWorldEvent event) {
        if (NewNPC.getNPCs() != null & !NewNPC.getNPCs().isEmpty()) {
            NewNPC.addJoinPacket(event.getPlayer());
        }
    }

    public void loadNPC() {
        YamlConfiguration file = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "NPC.yml"));
        if (file.contains("data")) {
            try {
                for (String key : file.getConfigurationSection("data").getKeys(false)) {
                    Location location = new Location(Bukkit.getWorld((String)file.getString("data." + key + ".world")), file.getDouble("data." + key + ".x"), file.getDouble("data." + key + ".y"), file.getDouble("data." + key + ".z"), (float)file.getDouble("data." + key + ".yaw"), (float)file.getDouble("data." + key + ".pitch"));
                    String name = file.getString("data." + key + ".name");
                    GameProfile gameProfile = new GameProfile(UUID.randomUUID(), name);
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", file.getString("data." + key + ".text"), file.getString("data." + key + ".signature")));
                    NewNPC.loadNPC(location, gameProfile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

