/*
 * Decompiled with CFR 0.152.
 */
package me.F_o_F_1092.MysteriousHalloween.WitchGame;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.F_o_F_1092.MysteriousHalloween.WitchGame.WitchGame;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class WitchGameListener {
    static List<WitchGame> witchGames = new ArrayList<WitchGame>();

    public static void addWitchGame(WitchGame witchGame) {
        witchGames.add(witchGame);
    }

    public static void deleteWitchGame(String gameName) {
        WitchGame witchGame = WitchGameListener.getWitchGame(gameName);
        witchGame.delete();
        witchGames.remove(witchGame);
    }

    public static List<WitchGame> getAllWitchGames() {
        return witchGames;
    }

    public static boolean isWitchGameExsisting(String gameName) {
        return WitchGameListener.getWitchGame(gameName) != null;
    }

    public static WitchGame getWitchGame(String gameName) {
        for (WitchGame witchGame : witchGames) {
            if (!witchGame.getGameName().equalsIgnoreCase(gameName)) continue;
            return witchGame;
        }
        return null;
    }

    public static WitchGame getRandomgGame() {
        if (witchGames.isEmpty()) {
            return null;
        }
        Random rnd = new Random();
        int gameNumber = rnd.nextInt(witchGames.size());
        return witchGames.get(gameNumber);
    }

    public static Location getRandomgGameSpawnLocation(WitchGame witchGame) {
        Random rnd = new Random();
        int gameLocation = rnd.nextInt(witchGame.getGameMaxLocations());
        return witchGame.getGameLocation(gameLocation);
    }

    public static void loadAllWitchGames() {
        File fileConfig = new File("plugins/MysteriousHalloween/Config.yml");
        YamlConfiguration ymlFileConfig = YamlConfiguration.loadConfiguration((File)fileConfig);
        if (ymlFileConfig.contains("WitchGame")) {
            for (String gameName : ymlFileConfig.getConfigurationSection("WitchGame").getKeys(false)) {
                WitchGame witchGame = new WitchGame(gameName);
                witchGame.setGameText(ymlFileConfig.getString("WitchGame." + gameName + ".Text"));
                for (Object loc : ymlFileConfig.getList("WitchGame." + gameName + ".Locations")) {
                    witchGame.addGameLocation((Location)loc);
                }
                witchGame.setLeftWeapon(ymlFileConfig.getItemStack("WitchGame." + gameName + ".WeaponLeft"));
                witchGame.setRightWeapon(ymlFileConfig.getItemStack("WitchGame." + gameName + ".WeaponRight"));
                witchGame.setHealth(ymlFileConfig.getDouble("WitchGame." + gameName + ".Health"));
                int armori = 0;
                for (Object witchArmor : ymlFileConfig.getList("WitchGame." + gameName + ".Armor")) {
                    witchGame.setArmor(armori, (ItemStack)witchArmor);
                    ++armori;
                }
                int dropsi = 0;
                for (Object witchDrops : ymlFileConfig.getList("WitchGame." + gameName + ".Drops")) {
                    witchGame.setDrops(dropsi, (ItemStack)witchDrops);
                    ++dropsi;
                }
                WitchGameListener.addWitchGame(witchGame);
            }
        }
    }
}

