/*
 * Decompiled with CFR 0.152.
 */
package me.F_o_F_1092.MysteriousHalloween.WitchGame;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WitchGame {
    Double health;
    String gameName;
    String gameText;
    List<Location> gameLocations = new ArrayList<Location>();
    ItemStack weaponRight;
    ItemStack weaponLeft;
    ItemStack[] armor = new ItemStack[4];
    ItemStack[] drops = new ItemStack[8];

    public WitchGame(String gameName) {
        this.gameName = gameName;
    }

    public String getGameName() {
        return this.gameName;
    }

    public void addGameLocation(Location loc) {
        this.gameLocations.add(loc.getBlock().getLocation());
    }

    public Location getGameLocation(int gameLocationNumber) {
        return this.gameLocations.get(gameLocationNumber);
    }

    public void removeGameLocation(int gameLocationNumber) {
        this.gameLocations.remove(gameLocationNumber);
    }

    public int getGameMaxLocations() {
        return this.gameLocations.size();
    }

    public void setGameText(String gameText) {
        this.gameText = gameText;
    }

    String getGameText() {
        return this.gameText;
    }

    public Inventory openWitchInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00c2\u00a7f[\u00c2\u00a76Mysterious\u00c2\u00a7eHalloween\u00c2\u00a7f]");
        int i = 0;
        while (i < 36) {
            Random rnd = new Random();
            int color = rnd.nextInt(2) + 1;
            if (color == 1) {
                inv.setItem(i, new ItemStack(Material.STAINED_GLASS_PANE, 1, 4));
            } else if (color == 2) {
                inv.setItem(i, new ItemStack(Material.STAINED_GLASS_PANE, 1, 1));
            }
            ++i;
        }
        inv.setItem(1, this.armor[0]);
        inv.setItem(10, this.armor[1]);
        inv.setItem(19, this.armor[2]);
        inv.setItem(28, this.armor[3]);
        inv.setItem(9, this.weaponLeft);
        inv.setItem(11, this.weaponRight);
        inv.setItem(13, this.drops[0]);
        inv.setItem(14, this.drops[1]);
        inv.setItem(15, this.drops[2]);
        inv.setItem(16, this.drops[3]);
        inv.setItem(22, this.drops[4]);
        inv.setItem(23, this.drops[5]);
        inv.setItem(24, this.drops[6]);
        inv.setItem(25, this.drops[7]);
        return inv;
    }

    public void saveWitchInventory(Inventory inv) {
        int armor = 0;
        while (armor < 4) {
            if (inv.getItem(armor * 9 + 1) == null) {
                this.setArmor(armor, new ItemStack(Material.AIR));
            } else {
                this.setArmor(armor, inv.getItem(armor * 9 + 1));
            }
            ++armor;
        }
        this.weaponLeft = inv.getItem(9) == null ? new ItemStack(Material.AIR) : inv.getItem(9);
        this.weaponRight = inv.getItem(11) == null ? new ItemStack(Material.AIR) : inv.getItem(11);
        int drops = 0;
        while (drops < 7) {
            if (inv.getItem(drops + 19) == null) {
                this.setDrops(drops, new ItemStack(Material.AIR));
            } else {
                this.setDrops(drops, inv.getItem(drops + 19));
            }
            ++drops;
        }
        drops = 0;
        while (drops < 8) {
            if (drops < 4) {
                if (inv.getItem(drops + 13) == null) {
                    this.setDrops(drops, new ItemStack(Material.AIR));
                } else {
                    this.setDrops(drops, inv.getItem(drops + 13));
                }
            } else if (inv.getItem(drops + 18) == null) {
                this.setDrops(drops, new ItemStack(Material.AIR));
            } else {
                this.setDrops(drops, inv.getItem(drops + 18));
            }
            ++drops;
        }
    }

    void setArmor(int slot, ItemStack is) {
        this.armor[slot] = is;
    }

    void setLeftWeapon(ItemStack is) {
        this.weaponLeft = is;
    }

    void setRightWeapon(ItemStack is) {
        this.weaponRight = is;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    void setDrops(int slot, ItemStack is) {
        this.drops[slot] = is;
    }

    ItemStack[] getArmor() {
        return this.armor;
    }

    ItemStack getLeftWeapon() {
        return this.weaponLeft;
    }

    ItemStack getRightWeapon() {
        return this.weaponRight;
    }

    Double getHealth() {
        return this.health;
    }

    ItemStack[] getDrops() {
        return this.drops;
    }

    public void dropItems(Location loc) {
        int i = 0;
        while (i < 8) {
            if (this.drops[i].getType() != Material.AIR) {
                loc.getWorld().dropItem(loc, this.drops[i]);
            }
            ++i;
        }
    }

    public void save() {
        File fileConfig = new File("plugins/MysteriousHalloween/Config.yml");
        YamlConfiguration ymlFileConfig = YamlConfiguration.loadConfiguration((File)fileConfig);
        try {
            ymlFileConfig.set("WitchGame." + this.gameName + ".Text", (Object)this.gameText);
            ymlFileConfig.set("WitchGame." + this.gameName + ".Text", (Object)this.gameText);
            ymlFileConfig.set("WitchGame." + this.gameName + ".Locations", this.gameLocations);
            ymlFileConfig.set("WitchGame." + this.gameName + ".WeaponLeft", (Object)this.weaponLeft);
            ymlFileConfig.set("WitchGame." + this.gameName + ".Health", (Object)this.health);
            ArrayList<ItemStack> witchArmor = new ArrayList<ItemStack>();
            witchArmor.add(this.armor[0]);
            witchArmor.add(this.armor[1]);
            witchArmor.add(this.armor[2]);
            witchArmor.add(this.armor[3]);
            ymlFileConfig.set("WitchGame." + this.gameName + ".Armor", witchArmor);
            ArrayList<ItemStack> witchDrops = new ArrayList<ItemStack>();
            witchDrops.add(this.drops[0]);
            witchDrops.add(this.drops[1]);
            witchDrops.add(this.drops[2]);
            witchDrops.add(this.drops[3]);
            witchDrops.add(this.drops[4]);
            witchDrops.add(this.drops[5]);
            witchDrops.add(this.drops[6]);
            witchDrops.add(this.drops[7]);
            ymlFileConfig.set("WitchGame." + this.gameName + ".Drops", witchDrops);
            ymlFileConfig.save(fileConfig);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void delete() {
        File fileConfig = new File("plugins/MysteriousHalloween/Config.yml");
        YamlConfiguration ymlFileConfig = YamlConfiguration.loadConfiguration((File)fileConfig);
        try {
            ymlFileConfig.save(fileConfig);
            ymlFileConfig.set("WitchGame." + this.gameName, null);
            ymlFileConfig.save(fileConfig);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

