/*
 * Decompiled with CFR 0.152.
 */
package net.nojolp.MultiaccountFinder.Utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.nojolp.MultiaccountFinder.MultiaccountFinder;
import net.nojolp.MultiaccountFinder.Utils.SQLStatementParameter;
import net.nojolp.MultiaccountFinder.Utils.SQLStatementParameterType;

public class MySQL {
    private final MultiaccountFinder plugin;

    public MySQL(MultiaccountFinder multiaccountFinder) {
        this.plugin = multiaccountFinder;
    }

    public void connect() {
        if (this.isConnected()) {
            this.close();
        }
        try {
            Connection con = DriverManager.getConnection("jdbc:mysql://" + this.plugin.mysqlHost + ":" + this.plugin.mysqlPort + "/" + this.plugin.mysqlDatabase + "?autoReconnect=true", this.plugin.mysqlUser, this.plugin.mysqlPassword);
            con.setAutoCommit(false);
            this.plugin.setCon(con);
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.plugin.prefix + "\u00a77MySQL \u00a7asuccessfully \u00a77connected to the database"});
        }
        catch (Exception ex) {
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.plugin.prefix + "\u00a7cCould not connect to MySQL! Plugin doesn't work! Please PM Noali2000 with the following StackTrace on the SpigotForums, if you belive this is a plugin error!"});
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.plugin.prefix + "\u00a77================================\u00a74COPY STACK TRACE FROM HERE\u00a77================================"});
            ex.printStackTrace();
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.plugin.prefix + "\u00a77================================\u00a74COPY STACK TRACE UP TO HERE\u00a77================================"});
        }
    }

    public void close() {
        if (this.isConnected()) {
            try {
                this.plugin.getCon().close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return this.plugin.getCon() != null;
    }

    public void createTable() {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            PreparedStatement create1 = this.plugin.getCon().prepareStatement("CREATE TABLE IF NOT EXISTS multiaccountmanager_logins(id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, playername VARCHAR(100), uuid VARCHAR(100), ip VARCHAR(100), time VARCHAR(100), millitime BIGINT)");
            PreparedStatement create2 = this.plugin.getCon().prepareStatement("CREATE TABLE IF NOT EXISTS multiaccountmanager_users(id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(100), playername VARCHAR(100))");
            create1.executeUpdate();
            create2.executeUpdate();
        }
        catch (Exception ex) {
            this.plugin.getProxy().getConsole().sendMessage(this.plugin.prefix + "\u00a7cCould not create the MySQL Table!");
        }
    }

    public void update(String qry, ArrayList<SQLStatementParameter> parameters) {
        try {
            PreparedStatement ps = this.plugin.getCon().prepareStatement(qry);
            for (SQLStatementParameter parameter : parameters) {
                switch (parameter.type) {
                    case STRING: {
                        ps.setString(parameter.index, (String)parameter.value);
                        break;
                    }
                    case INT: {
                        ps.setInt(parameter.index, (Integer)parameter.value);
                        break;
                    }
                    case DOUBLE: {
                        ps.setDouble(parameter.index, (Double)parameter.value);
                        break;
                    }
                    case BOOL: {
                        ps.setBoolean(parameter.index, (Boolean)parameter.value);
                        break;
                    }
                    case LONG: {
                        ps.setLong(parameter.index, (Long)parameter.value);
                    }
                }
            }
            ps.executeUpdate();
            this.plugin.getCon().commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.plugin.getCon().rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public ResultSet getResult(String qry, ArrayList<SQLStatementParameter> parameters) {
        try {
            PreparedStatement ps = this.plugin.getCon().prepareStatement(qry);
            for (SQLStatementParameter parameter : parameters) {
                switch (parameter.type) {
                    case STRING: {
                        ps.setString(parameter.index, (String)parameter.value);
                        break;
                    }
                    case INT: {
                        ps.setInt(parameter.index, (Integer)parameter.value);
                        break;
                    }
                    case DOUBLE: {
                        ps.setDouble(parameter.index, (Double)parameter.value);
                        break;
                    }
                    case BOOL: {
                        ps.setBoolean(parameter.index, (Boolean)parameter.value);
                        break;
                    }
                    case LONG: {
                        ps.setLong(parameter.index, (Long)parameter.value);
                    }
                }
            }
            return ps.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasAccount(final UUID uuid) {
        try {
            boolean isInDatabase = false;
            ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_users WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
                {
                    this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid.toString()));
                }
            });
            isInDatabase = rs.next();
            return isInDatabase;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void createEntry(ProxiedPlayer p) {
        String[] ipsplit = p.getAddress().toString().split(":");
        String ip = ipsplit[0];
        ip = ip.replace("/", "");
        Date zeitstempel = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String df = simpleDateFormat.format(zeitstempel);
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getName()));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, p.getUniqueId().toString()));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 3, ip));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 4, df));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.LONG, 5, System.currentTimeMillis()));
        this.update("INSERT INTO multiaccountmanager_logins (playername, uuid, ip, time, millitime) VALUES(?, ?, ?, ?, ?)", parameters);
    }

    public void createAccount(final UUID uuid, String name) {
        try {
            ResultSet test = this.getResult("SELECT uuid FROM multiaccountmanager_users WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
                {
                    this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid.toString()));
                }
            });
            if (!test.next()) {
                ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid.toString()));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
                this.update("INSERT INTO multiaccountmanager_users (uuid, playername) VALUES(?, ?)", parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getLoginCount() {
        int count = 0;
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins", new ArrayList<SQLStatementParameter>());
        try {
            while (rs.next()) {
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    public String getLastLoginIP(final String uuid) {
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins WHERE uuid = ? ORDER BY millitime DESC LIMIT 1", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("ip");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getLastLogin(final String uuid) {
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins WHERE uuid = ? ORDER BY millitime DESC LIMIT 1", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid));
            }
        });
        try {
            if (rs.next()) {
                return "\u00a77At\u00a78: \u00a7e" + rs.getString("time") + " \u00a77from the IP Address\u00a78: \u00a7e" + rs.getString("ip");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<String> getLoginsByName(final String uuid) {
        ArrayList<String> logins = new ArrayList<String>();
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins WHERE uuid = ? AND millitime > ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid));
                this.add(new SQLStatementParameter(SQLStatementParameterType.LONG, 2, System.currentTimeMillis() - 86400000L));
            }
        });
        try {
            while (rs.next()) {
                logins.add("\u00a77As\u00a78: \u00a7c" + rs.getString("playername") + " \u00a77at\u00a78: \u00a7e" + rs.getString("time") + " \u00a77from the IP Address\u00a78: \u00a7e" + rs.getString("ip"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return logins;
    }

    public ArrayList<String> getLoginsByIP(final String ip) {
        ArrayList<String> logins = new ArrayList<String>();
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins WHERE ip = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, ip));
            }
        });
        try {
            while (rs.next()) {
                logins.add("\u00a77As\u00a78: \u00a7e" + rs.getString("playername") + " \u00a77at\u00a78: \u00a7e" + rs.getString("time"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return logins;
    }

    public ArrayList<String> getSecondAccounts(final String ip) {
        ArrayList<String> logins = new ArrayList<String>();
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_logins WHERE ip = ? AND millitime > ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, ip));
                this.add(new SQLStatementParameter(SQLStatementParameterType.LONG, 2, System.currentTimeMillis() - 86400000L));
            }
        });
        try {
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                if (logins.contains(uuid)) continue;
                logins.add(uuid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return logins;
    }

    public String getName(final String uuid) {
        String name = null;
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_users WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid));
            }
        });
        try {
            while (rs.next()) {
                name = rs.getString("playername");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return name;
    }

    public String getUUID(final String name) {
        String uuid = null;
        ResultSet rs = this.getResult("SELECT * FROM multiaccountmanager_users WHERE playername = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            while (rs.next()) {
                uuid = rs.getString("uuid");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uuid;
    }

    public void setName(UUID uuid, String name) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, uuid.toString()));
        this.update("UPDATE multiaccountmanager_users SET playername = ? WHERE uuid = ?", parameters);
    }
}

