/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.msg.spigot.commands;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.spigotmc.msg.spigot.Msg;
import org.spigotmc.msg.spigot.commands.MsgCommand;

public class ReplyCommand
implements CommandExecutor {
    private final Msg msg;

    public ReplyCommand(Msg msg) {
        this.msg = msg;
        msg.getCommand("r").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String targetReplacement;
        String playerReplacement;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("msg.use")) {
            player.sendMessage(this.msg.translate("noPermission"));
            return false;
        }
        if (args.length <= 0) {
            player.sendMessage(this.msg.translate("usage"));
            return false;
        }
        if (!MsgCommand.MSG_MAP.containsKey(player.getUniqueId())) {
            player.sendMessage(this.msg.translate("haveNotReceivedAMessageYet"));
            return false;
        }
        Player target = Bukkit.getPlayer((UUID)MsgCommand.MSG_MAP.get(player.getUniqueId()));
        if (target == null) {
            player.sendMessage(this.msg.translate("playerIsOffline"));
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        if (this.msg.getDataFile().get().getBoolean(target.getUniqueId().toString() + ".deactivated")) {
            player.sendMessage(this.msg.translate("notAllowed"));
            return false;
        }
        String playerMsg = this.msg.translate("playerMessage");
        String targetMsg = this.msg.translate("targetMessage");
        if (!this.msg.getConfigFile().get().getBoolean("UseDisplayNames")) {
            playerReplacement = player.getName();
            targetReplacement = target.getName();
        } else {
            playerReplacement = ChatColor.RESET + player.getDisplayName();
            targetReplacement = ChatColor.RESET + target.getDisplayName();
        }
        player.sendMessage(playerMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        target.sendMessage(targetMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        MsgCommand.MSG_MAP.put(target.getUniqueId(), player.getUniqueId());
        return false;
    }
}

