/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.msg.spigot.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.spigotmc.msg.spigot.Msg;

public class MsgCommand
implements CommandExecutor {
    private final Msg msg;
    public static final Map<UUID, UUID> MSG_MAP = new HashMap<UUID, UUID>();

    public MsgCommand(Msg msg) {
        this.msg = msg;
        msg.getCommand("msg").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String targetReplacement;
        String playerReplacement;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("toggle")) {
                if (!player.hasPermission("msg.toggle")) {
                    player.sendMessage(this.msg.translate("noPermission"));
                    return false;
                }
                if (!this.msg.getDataFile().get().getBoolean(player.getUniqueId().toString() + ".deactivated")) {
                    this.msg.getDataFile().get().set(player.getUniqueId().toString() + ".deactivated", (Object)true);
                    player.sendMessage(this.msg.translate("deactivated"));
                } else {
                    this.msg.getDataFile().get().set(player.getUniqueId().toString() + ".deactivated", (Object)false);
                    player.sendMessage(this.msg.translate("activated"));
                }
                this.msg.getDataFile().save();
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!player.hasPermission("msg.reload")) {
                    player.sendMessage(this.msg.translate("noPermission"));
                    return false;
                }
                this.msg.getConfigFile().reload();
                this.msg.getDataFile().reload();
                player.sendMessage(this.msg.translate("Reloaded"));
                return false;
            }
        }
        if (!player.hasPermission("msg.use")) {
            player.sendMessage(this.msg.translate("noPermission"));
            return false;
        }
        if (args.length <= 1) {
            player.sendMessage(this.msg.translate("usage"));
            return false;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(this.msg.translate("playerIsOffline"));
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            builder.append(args[i]).append(" ");
        }
        if (player.getUniqueId().equals(target.getUniqueId())) {
            player.sendMessage(this.msg.translate("targetCanNotBeTheSender"));
            return false;
        }
        if (this.msg.getDataFile().get().getBoolean(target.getUniqueId().toString() + ".deactivated")) {
            player.sendMessage(this.msg.translate("notAllowed"));
            return false;
        }
        String playerMsg = this.msg.translate("playerMessage");
        String targetMsg = this.msg.translate("targetMessage");
        if (!this.msg.getConfigFile().get().getBoolean("UseDisplayNames")) {
            playerReplacement = player.getName();
            targetReplacement = target.getName();
        } else {
            playerReplacement = ChatColor.RESET + player.getDisplayName();
            targetReplacement = ChatColor.RESET + target.getDisplayName();
        }
        player.sendMessage(playerMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        target.sendMessage(targetMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        MSG_MAP.put(target.getUniqueId(), player.getUniqueId());
        return false;
    }
}

