/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.msg.bungeecord.files;

import java.io.File;
import java.io.IOException;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import org.spigotmc.msg.bungeecord.Msg;

public class Config {
    private final Msg msg;
    private File file;
    private Configuration config;
    private final String fileName;

    public Config(Msg msg, String fileName) {
        this.msg = msg;
        this.fileName = fileName;
        this.setup();
    }

    public void setup() {
        boolean b = false;
        if (!this.msg.getDataFolder().exists()) {
            this.msg.getDataFolder().mkdir();
        }
        this.file = new File(this.msg.getDataFolder().getPath(), this.fileName + ".yml");
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
                b = true;
            }
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
            if (this.fileName.equals("config") && b) {
                this.setConfigDefaults();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setConfigDefaults() {
        this.config.set("UseDisplayNames", (Object)false);
        this.config.set("prefix", (Object)"&7[&eYourNetwork.com&7]&r");
        this.config.set("noPermission", (Object)"%prefix% &cYou don't have permission to perform this command.");
        this.config.set("usage", (Object)"%prefix% &cUsage: /msg <player> <message>");
        this.config.set("haveNotReceivedAMessageYet", (Object)"%prefix% &cYou have not received a message yet.");
        this.config.set("playerIsOffline", (Object)"%prefix% &cplayer is not online.");
        this.config.set("targetCanNotBeTheSender", (Object)"%prefix% &cYou can not send message to yourself.");
        this.config.set("playerMessage", (Object)"%prefix% &cYou &8>> &c%receiverName% &8>> &7%message%");
        this.config.set("targetMessage", (Object)"%prefix% &c%senderName% &8>> &cYou &8>> &7%message%");
        this.config.set("notAllowed", (Object)"%prefix% &cThe messaged player has deactivated privat messages.");
        this.config.set("activated", (Object)"%prefix% &aYou activated private messages.");
        this.config.set("deactivated", (Object)"%prefix% &cYou deactivated private messages.");
        this.config.set("Reloaded", (Object)"%prefix% &aThe plugin has been reloaded.");
        this.save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

