/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.msg.bungeecord.commands;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import org.spigotmc.msg.bungeecord.Msg;
import org.spigotmc.msg.bungeecord.commands.MsgCommand;

public class ReplyCommand
extends Command {
    private final Msg msg;

    public ReplyCommand(String name, Msg msg) {
        super(name);
        this.msg = msg;
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)msg, (Command)this);
    }

    public void execute(CommandSender commandSender, String[] args) {
        String targetReplacement;
        String playerReplacement;
        if (!(commandSender instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)commandSender;
        if (!player.hasPermission("msg.use")) {
            player.sendMessage(this.msg.translate("noPermission"));
            return;
        }
        if (args.length <= 0) {
            player.sendMessage(this.msg.translate("usage"));
            return;
        }
        if (!MsgCommand.MSG_MAP.containsKey(player.getUniqueId())) {
            player.sendMessage("haveNotReceivedAMessageYet");
            return;
        }
        ProxiedPlayer target = ProxyServer.getInstance().getPlayer(MsgCommand.MSG_MAP.get(player.getUniqueId()));
        if (target == null) {
            player.sendMessage(this.msg.translate("playerIsOffline"));
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        if (this.msg.getSaves().getConfig().getBoolean(target.getUniqueId().toString() + ".deactivated")) {
            player.sendMessage(this.msg.translate("notAllowed"));
            return;
        }
        String playerMsg = this.msg.translate("playerMessage");
        String targetMsg = this.msg.translate("targetMessage");
        if (!this.msg.getConfig().getConfig().getBoolean("UseDisplayNames")) {
            playerReplacement = player.getName();
            targetReplacement = target.getName();
        } else {
            playerReplacement = ChatColor.RESET + player.getDisplayName();
            targetReplacement = ChatColor.RESET + target.getDisplayName();
        }
        player.sendMessage(playerMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        target.sendMessage(targetMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        MsgCommand.MSG_MAP.put(target.getUniqueId(), player.getUniqueId());
    }
}

