/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.msg.bungeecord.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import org.spigotmc.msg.bungeecord.Msg;

public class MsgCommand
extends Command {
    private final Msg msg;
    public static final Map<UUID, UUID> MSG_MAP = new HashMap<UUID, UUID>();

    public MsgCommand(String name, Msg msg) {
        super(name);
        this.msg = msg;
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)msg, (Command)this);
    }

    public void execute(CommandSender sender, String[] args) {
        String targetReplacement;
        String playerReplacement;
        if (!(sender instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("toggle")) {
                if (!player.hasPermission("msg.toggle")) {
                    player.sendMessage(this.msg.translate("noPermission"));
                    return;
                }
                if (!this.msg.getSaves().getConfig().getBoolean(player.getUniqueId().toString() + ".deactivated")) {
                    this.msg.getSaves().getConfig().set(player.getUniqueId().toString() + ".deactivated", (Object)true);
                    player.sendMessage(this.msg.translate("deactivated"));
                } else {
                    this.msg.getSaves().getConfig().set(player.getUniqueId().toString() + ".deactivated", (Object)false);
                    player.sendMessage(this.msg.translate("activated"));
                }
                this.msg.getSaves().save();
                return;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!player.hasPermission("msg.reload")) {
                    player.sendMessage(this.msg.translate("noPermission"));
                    return;
                }
                this.msg.getConfig().reload();
                this.msg.getSaves().reload();
                player.sendMessage(this.msg.translate("Reloaded"));
                return;
            }
        }
        if (!player.hasPermission("msg.use")) {
            player.sendMessage(this.msg.translate("noPermission"));
            return;
        }
        if (args.length <= 1) {
            player.sendMessage(this.msg.translate("usage"));
            return;
        }
        ProxiedPlayer target = ProxyServer.getInstance().getPlayer(args[0]);
        if (target == null) {
            player.sendMessage(this.msg.translate("playerIsOffline"));
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            builder.append(args[i]).append(" ");
        }
        if (player.getUniqueId().equals(target.getUniqueId())) {
            player.sendMessage(this.msg.translate("targetCanNotBeTheSender"));
            return;
        }
        if (this.msg.getSaves().getConfig().getBoolean(target.getUniqueId().toString() + ".deactivated")) {
            player.sendMessage(this.msg.translate("notAllowed"));
            return;
        }
        String playerMsg = this.msg.translate("playerMessage");
        String targetMsg = this.msg.translate("targetMessage");
        if (!this.msg.getConfig().getConfig().getBoolean("UseDisplayNames")) {
            playerReplacement = player.getName();
            targetReplacement = target.getName();
        } else {
            playerReplacement = ChatColor.RESET + player.getDisplayName();
            targetReplacement = ChatColor.RESET + target.getDisplayName();
        }
        player.sendMessage(playerMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        target.sendMessage(targetMsg.replaceAll("%senderName%", playerReplacement).replaceAll("%receiverName%", targetReplacement).replaceAll("%message%", builder.toString()));
        MSG_MAP.put(target.getUniqueId(), player.getUniqueId());
    }
}

