/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.andrew28.morestorage.util.ReflectionUtil;

public class NBTUtil {
    private ReflectionUtil reflectionUtil;
    private Class<?> nbtTagCompoundClass;
    private Constructor<?> nbtTagCompoundConstructor;
    private Class<?> nbtCompressedStreamToolsClass;
    private Method saveNBTToStreamMethod;
    private Method readNBTFromStreamMethod;

    public NBTUtil(ReflectionUtil reflectionUtil) throws ReflectiveOperationException {
        this.reflectionUtil = reflectionUtil;
        this.nbtTagCompoundClass = reflectionUtil.getNMSClass("NBTTagCompound");
        this.nbtTagCompoundConstructor = this.nbtTagCompoundClass.getConstructor(new Class[0]);
        this.nbtCompressedStreamToolsClass = reflectionUtil.getNMSClass("NBTCompressedStreamTools");
        this.saveNBTToStreamMethod = this.nbtCompressedStreamToolsClass.getMethod("a", this.nbtTagCompoundClass, OutputStream.class);
        this.readNBTFromStreamMethod = this.nbtCompressedStreamToolsClass.getMethod("a", InputStream.class);
    }

    public Object getNewNbtTagCompound() throws ReflectiveOperationException {
        return this.nbtTagCompoundConstructor.newInstance(new Object[0]);
    }

    public void writeNBTTagCompoundToStream(Object nbtTagCompound, OutputStream outputStream) throws InvocationTargetException, IllegalAccessException {
        this.saveNBTToStreamMethod.invoke(null, nbtTagCompound, outputStream);
    }

    public Object readNBTTagCompoundFromStream(InputStream inputStream) throws ReflectiveOperationException {
        return this.readNBTFromStreamMethod.invoke(null, inputStream);
    }

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    public Class<?> getNbtTagCompoundClass() {
        return this.nbtTagCompoundClass;
    }

    public Constructor<?> getNbtTagCompoundConstructor() {
        return this.nbtTagCompoundConstructor;
    }

    public Class<?> getNbtCompressedStreamToolsClass() {
        return this.nbtCompressedStreamToolsClass;
    }

    public Method getSaveNBTToStreamMethod() {
        return this.saveNBTToStreamMethod;
    }

    public Method getReadNBTFromStreamMethod() {
        return this.readNBTFromStreamMethod;
    }
}

