/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class Messages {
    private File file;
    private Map<String, Object> messages = new HashMap<String, Object>();

    public Messages(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void load() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String key : config.getKeys(true)) {
            this.messages.put(key, config.get(key));
        }
    }

    public String getMessage(String key) {
        return (String)this.messages.get(key);
    }

    public String[] getMessages(String key) {
        return (String[])this.messages.get(key);
    }

    public void send(CommandSender sender, String key, Replacer ... replacers) {
        Object message = this.messages.get(key);
        if (message == null) {
            return;
        }
        if (message instanceof String) {
            String string2 = (String)message;
            string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
            if (replacers != null) {
                for (Replacer replacer : replacers) {
                    string2 = replacer.replace(string2);
                }
            }
            sender.sendMessage(string2);
        } else if (message instanceof List) {
            List<String> strings = (List<String>)message;
            strings = strings.stream().map(string -> {
                string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
                for (Replacer replacer : replacers) {
                    string = replacer.replace((String)string);
                }
                return string;
            }).collect(Collectors.toList());
            sender.sendMessage(strings.toArray(new String[strings.size()]));
        }
    }

    public static class Replacer {
        private String needle;
        private String replacement;

        public Replacer(String needle, String replacement) {
            this.needle = needle;
            this.replacement = replacement;
        }

        String replace(String haystack) {
            return haystack.replace(this.needle, this.replacement);
        }
    }
}

