/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.andrew28.morestorage.util.NBTUtil;
import me.andrew28.morestorage.util.ReflectionUtil;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    private NBTUtil nbtUtil;
    private Class<?> itemStackClass;
    private Constructor<?> itemStackNBTConstructor;
    private Method createStackMethod;
    private Method stackSaveMethod;
    private Method getItemMethod;
    private Class<?> itemClass;
    private Object registry;
    private Field registryField;
    private Class<?> craftItemStackClass;
    private Method asNMSCopyMethod;
    private Method asBukkitCopyMethod;
    private Method fromItemMethod;
    private Field itemStackField;
    private Class<?> minecraftKeyClass;
    private Constructor<?> minecraftKeyConstructor;
    private Class<?> registryMaterialsClass;
    private Method mcIdFromNMSStackMethod;
    private Method itemFromMcIdMethod;

    public ItemUtil(NBTUtil nbtUtil) throws ReflectiveOperationException {
        Validate.notNull((Object)nbtUtil, (String)"The NBTUtil cannot be null.");
        this.nbtUtil = nbtUtil;
        ReflectionUtil reflectionUtil = nbtUtil.getReflectionUtil();
        Class<?> nbtTagCompoundClass = nbtUtil.getNbtTagCompoundClass();
        this.itemStackClass = reflectionUtil.getNMSClass("ItemStack");
        try {
            this.itemStackNBTConstructor = this.itemStackClass.getConstructor(nbtTagCompoundClass);
        }
        catch (NoSuchMethodException e) {
            this.createStackMethod = this.itemStackClass.getMethod("createStack", nbtTagCompoundClass);
        }
        this.getItemMethod = this.itemStackClass.getMethod("getItem", new Class[0]);
        this.stackSaveMethod = this.itemStackClass.getMethod("save", nbtTagCompoundClass);
        this.itemClass = reflectionUtil.getNMSClass("Item");
        this.registryField = this.itemClass.getDeclaredField("REGISTRY");
        this.craftItemStackClass = reflectionUtil.getOBCClass("inventory.CraftItemStack");
        this.asNMSCopyMethod = this.craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
        this.asBukkitCopyMethod = this.craftItemStackClass.getMethod("asBukkitCopy", this.itemStackClass);
        this.fromItemMethod = this.craftItemStackClass.getMethod("asNewCraftStack", this.itemClass);
        this.itemStackField = this.craftItemStackClass.getDeclaredField("handle");
        this.itemStackField.setAccessible(true);
        this.minecraftKeyClass = reflectionUtil.getNMSClass("MinecraftKey");
        this.minecraftKeyConstructor = this.minecraftKeyClass.getConstructor(String.class);
        this.registryMaterialsClass = reflectionUtil.getNMSClass("RegistryMaterials");
        this.mcIdFromNMSStackMethod = this.registryMaterialsClass.getMethod("b", Object.class);
        this.itemFromMcIdMethod = this.registryMaterialsClass.getMethod("get", Object.class);
    }

    public Object getNMSItemStack(ItemStack itemStack) throws ReflectiveOperationException {
        return this.asNMSCopyMethod.invoke(null, itemStack);
    }

    public Object getItemFromNMSStack(Object nmsStack) throws ReflectiveOperationException {
        return this.getItemMethod.invoke(nmsStack, new Object[0]);
    }

    public Object getCraftItemStackFromItem(Object item) throws ReflectiveOperationException {
        return this.fromItemMethod.invoke(null, item);
    }

    public Object getItemRegistry() throws IllegalAccessException {
        if (this.registry == null) {
            this.registry = this.registryField.get(null);
        }
        return this.registry;
    }

    public String getMinecraftId(Material material) throws ReflectiveOperationException {
        Object nmsItemStack = this.getNMSItemStack(new ItemStack(material));
        Object item = this.getItemFromNMSStack(nmsItemStack);
        Object registry = this.getItemRegistry();
        Object minecraftKey = this.mcIdFromNMSStackMethod.invoke(registry, item);
        return minecraftKey.toString();
    }

    public Material getMaterialByMinecraftId(String id) throws ReflectiveOperationException {
        Object registry = this.getItemRegistry();
        Object mcKey = this.minecraftKeyConstructor.newInstance(id);
        Object item = this.itemFromMcIdMethod.invoke(registry, mcKey);
        if (item == null) {
            return null;
        }
        Object nmsItemStack = this.getNMSItemStackFromCraftItemStack(this.getCraftItemStackFromItem(item));
        return this.getItemStackFromNMSItemStack(nmsItemStack).getType();
    }

    public Object saveItemStackToNBT(ItemStack itemStack) throws ReflectiveOperationException {
        Object nbtTagCompound = this.nbtUtil.getNewNbtTagCompound();
        this.saveItemStackToNBT(itemStack, nbtTagCompound);
        return nbtTagCompound;
    }

    public void saveItemStackToNBT(ItemStack itemStack, Object nbtTagCompound) throws ReflectiveOperationException {
        if (nbtTagCompound == null) {
            nbtTagCompound = this.nbtUtil.getNewNbtTagCompound();
        }
        Object nmsItemStack = this.getNMSItemStack(itemStack);
        this.stackSaveMethod.invoke(nmsItemStack, nbtTagCompound);
    }

    public void serializeItemStack(ItemStack itemStack, OutputStream outputStream) throws ReflectiveOperationException {
        Validate.notNull((Object)itemStack, (String)"The ItemStack cannot be null.");
        Object nbtTagCompound = this.saveItemStackToNBT(itemStack);
        this.nbtUtil.writeNBTTagCompoundToStream(nbtTagCompound, outputStream);
    }

    public byte[] serializeItemStack(ItemStack itemStack) throws ReflectiveOperationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.serializeItemStack(itemStack, outputStream);
        return outputStream.toByteArray();
    }

    public ItemStack getItemStackFromNMSItemStack(Object nmsItemStack) throws ReflectiveOperationException {
        return (ItemStack)this.asBukkitCopyMethod.invoke(null, nmsItemStack);
    }

    public Object getNMSItemStackFromCraftItemStack(Object craftItemStack) throws IllegalAccessException {
        return this.itemStackField.get(craftItemStack);
    }

    public Object getNMSItemStackFromNBTTagCompound(Object nbtTagCompound) throws ReflectiveOperationException {
        if (this.itemStackNBTConstructor != null) {
            return this.itemStackNBTConstructor.newInstance(nbtTagCompound);
        }
        return this.createStackMethod.invoke(null, nbtTagCompound);
    }

    public ItemStack getItemStackFromNBTTagCompound(Object nbtTagCompound) throws ReflectiveOperationException {
        return this.getItemStackFromNMSItemStack(this.getNMSItemStackFromNBTTagCompound(nbtTagCompound));
    }

    public ItemStack deserializeItemStack(InputStream inputStream) throws ReflectiveOperationException {
        Object nbtTagCompound = this.nbtUtil.readNBTTagCompoundFromStream(inputStream);
        return this.getItemStackFromNBTTagCompound(nbtTagCompound);
    }

    public ItemStack deserializeItemStack(byte[] bytes) throws ReflectiveOperationException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return this.deserializeItemStack(inputStream);
    }

    public NBTUtil getNbtUtil() {
        return this.nbtUtil;
    }

    public Class<?> getItemStackClass() {
        return this.itemStackClass;
    }

    public Constructor<?> getItemStackNBTConstructor() {
        return this.itemStackNBTConstructor;
    }

    public Method getCreateStackMethod() {
        return this.createStackMethod;
    }

    public Method getStackSaveMethod() {
        return this.stackSaveMethod;
    }

    public Class<?> getCraftItemStackClass() {
        return this.craftItemStackClass;
    }

    public Method getAsNMSCopyMethod() {
        return this.asNMSCopyMethod;
    }

    public Method getAsBukkitCopyMethod() {
        return this.asBukkitCopyMethod;
    }
}

