/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import me.andrew28.morestorage.util.ReflectionUtil;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class EffectUtil {
    private Class<?> blockPositionClass;
    private Constructor blockPositionConstructor;
    private Class<?> blockClass;
    private Class<?> blocksClass;
    private Class<?> craftWorldClass;
    private Method getWorldHandleMethod;
    private Class<?> worldClass;
    private Method getTileEntityMethod;
    private Method playBlockActionMethod;
    private Class<?> tileEntityClass;
    private Method getBlockMethod;

    public EffectUtil(ReflectionUtil reflectionUtil) throws ReflectiveOperationException {
        Validate.notNull((Object)reflectionUtil, (String)"The ReflectionUtil cannot be null");
        this.blockPositionClass = reflectionUtil.getNMSClass("BlockPosition");
        this.blockPositionConstructor = this.blockPositionClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
        this.blockClass = reflectionUtil.getNMSClass("Block");
        this.blocksClass = reflectionUtil.getNMSClass("Blocks");
        this.craftWorldClass = reflectionUtil.getOBCClass("CraftWorld");
        this.getWorldHandleMethod = this.craftWorldClass.getDeclaredMethod("getHandle", new Class[0]);
        this.worldClass = reflectionUtil.getNMSClass("World");
        this.getTileEntityMethod = this.worldClass.getMethod("getTileEntity", this.blockPositionClass);
        this.playBlockActionMethod = this.worldClass.getMethod("playBlockAction", this.blockPositionClass, this.blockClass, Integer.TYPE, Integer.TYPE);
        this.tileEntityClass = reflectionUtil.getNMSClass("TileEntity");
        try {
            this.getBlockMethod = this.tileEntityClass.getDeclaredMethod("getBlock", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.getBlockMethod = this.tileEntityClass.getDeclaredMethod("w", new Class[0]);
        }
    }

    private Object getBlockPosition(Block block) throws ReflectiveOperationException {
        return this.getBlockPosition(block.getX(), block.getY(), block.getZ());
    }

    private Object getBlockPosition(int x, int y, int z) throws ReflectiveOperationException {
        return this.blockPositionConstructor.newInstance(x, y, z);
    }

    public void changeChestOpenState(Block block, boolean open) throws ReflectiveOperationException {
        if (block == null || block.getType() != Material.CHEST && block.getType() != Material.ENDER_CHEST || block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        Object blockPosition = this.getBlockPosition(block);
        World world = block.getWorld();
        Object nmsWorld = this.getWorldHandleMethod.invoke((Object)world, new Object[0]);
        Object tileEntity = this.getTileEntityMethod.invoke(nmsWorld, blockPosition);
        Object nmsBlock = this.getBlockMethod.invoke(tileEntity, new Object[0]);
        this.playBlockActionMethod.invoke(nmsWorld, blockPosition, nmsBlock, 1, open ? 1 : 0);
    }
}

