/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.recipe;

import me.andrew28.morestorage.recipe.CustomRecipe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class ShapelessCustomRecipe
extends CustomRecipe {
    private ItemStack[] itemStacks;
    private Plugin plugin;
    private String key;

    public ShapelessCustomRecipe(ItemStack result, Plugin plugin, String key, ItemStack[] itemStacks) {
        super(CustomRecipe.CustomRecipeType.SHAPELESS, result);
        this.itemStacks = itemStacks;
        this.plugin = plugin;
        this.key = key;
    }

    public ItemStack[] getItemStacks() {
        return this.itemStacks;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void register() {
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, this.key);
        ShapelessRecipe recipe = new ShapelessRecipe(namespacedKey, this.result);
        for (ItemStack itemStack : this.itemStacks) {
            recipe.addIngredient(itemStack.getType());
        }
        try {
            this.plugin.getServer().addRecipe((Recipe)recipe);
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Could not register duplicate recipe: " + namespacedKey);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapelessCustomRecipe)) {
            return false;
        }
        ShapelessCustomRecipe that = (ShapelessCustomRecipe)o;
        return new EqualsBuilder().append((Object[])this.itemStacks, (Object[])that.itemStacks).append((Object)this.key, (Object)that.key).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object[])this.itemStacks).append((Object)this.key).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("itemStacks", (Object[])this.itemStacks).append("key", (Object)this.key).toString();
    }
}

