/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.recipe;

import java.util.ArrayList;
import java.util.Map;
import me.andrew28.morestorage.recipe.CustomRecipe;
import me.andrew28.morestorage.util.ListUtil;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class ShapedCustomRecipe
extends CustomRecipe {
    private Map<Character, ItemStack> map;
    private Plugin plugin;
    private String key;
    private String[] pattern;
    private ItemStack[][] matrix;

    public ShapedCustomRecipe(ItemStack result, Plugin plugin, String key, Map<Character, ItemStack> map, String[] pattern) {
        super(CustomRecipe.CustomRecipeType.SHAPED, result);
        this.map = map;
        this.plugin = plugin;
        this.key = key;
        this.pattern = pattern;
    }

    public Map<Character, ItemStack> getMap() {
        return this.map;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getPattern() {
        return this.pattern;
    }

    public ItemStack[][] getMatrix() {
        if (this.matrix == null) {
            ArrayList matrixList = new ArrayList();
            for (String rowPattern : this.pattern) {
                ArrayList<ItemStack> squareMatrixRow = new ArrayList<ItemStack>();
                for (int column = 0; column < rowPattern.length(); ++column) {
                    char character = rowPattern.charAt(column);
                    squareMatrixRow.add(this.map.get(Character.valueOf(character)));
                }
                if (squareMatrixRow.size() < 1) continue;
                matrixList.add(squareMatrixRow);
            }
            this.matrix = ListUtil.toArray(matrixList, ItemStack.class, ItemStack[].class);
        }
        return this.matrix;
    }

    @Override
    public void register() {
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, this.key);
        ShapedRecipe shapedRecipe = new ShapedRecipe(namespacedKey, this.result);
        shapedRecipe.shape(this.pattern);
        for (Map.Entry<Character, ItemStack> entry : this.map.entrySet()) {
            shapedRecipe.setIngredient(entry.getKey().charValue(), entry.getValue().getType());
        }
        try {
            this.plugin.getServer().addRecipe((Recipe)shapedRecipe);
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Could not register duplicate recipe: " + namespacedKey);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapedCustomRecipe)) {
            return false;
        }
        ShapedCustomRecipe that = (ShapedCustomRecipe)o;
        return new EqualsBuilder().append(this.map, that.map).append((Object)this.key, (Object)that.key).append((Object[])this.pattern, (Object[])that.pattern).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.map).append((Object)this.key).append((Object[])this.pattern).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("map", this.map).append("key", (Object)this.key).append("pattern", (Object[])this.pattern).append("result", (Object)this.result).toString();
    }
}

