/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.save.ChunkChestData;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.plugin.Plugin;

public class WorldChunkListener
extends MoreStorageListener {
    private static final String DATA_FOLDER = "data/morestorage";
    private static final String CHEST_CHUNK_NAME_FORMAT = "chests.%d.%d.dat";
    private final Map<Chunk, Integer> chunkUnloadTaskIdMap = new ConcurrentHashMap<Chunk, Integer>();
    public Set<Chunk> loadedChunks = ConcurrentHashMap.newKeySet();
    public Set<Chunk> changedChunks = ConcurrentHashMap.newKeySet();
    private Map<Chunk, Long> lastLoadedTime = new ConcurrentHashMap<Chunk, Long>();

    public WorldChunkListener(MoreStorage moreStorage) {
        super(moreStorage);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        if (event.isNewChunk()) {
            return;
        }
        this.loadChunk(chunk);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        int viewDistance = this.moreStorage.getServer().getViewDistance() + 2;
        Location location = event.getPlayer().getLocation();
        World world = location.getWorld();
        for (int zPos = location.getBlockZ() + viewDistance; zPos > location.getBlockZ() - viewDistance; zPos -= 16) {
            for (int xPos = location.getBlockX() + viewDistance; xPos > location.getBlockX() - viewDistance; xPos -= 16) {
                this.loadChunk(new Location(world, (double)xPos, 0.0, (double)zPos).getChunk());
            }
        }
    }

    private void loadChunk(Chunk chunk) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.moreStorage, () -> {
            ChunkChestData data;
            if (this.loadedChunks.contains(chunk)) {
                this.lastLoadedTime.put(chunk, System.currentTimeMillis());
                return;
            }
            File chestDataFile = this.getChestDataFile(chunk);
            if (!chestDataFile.exists()) {
                return;
            }
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(chestDataFile));){
                data = (ChunkChestData)objectInputStream.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                this.logger.warning("Failed to read chest data from chunk " + chunk + ", possibly corrupted.");
                e.printStackTrace();
                return;
            }
            data.load(chunk, this.moreStorage);
            this.loadedChunks.add(chunk);
            this.lastLoadedTime.put(chunk, System.currentTimeMillis());
        });
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        if (this.chunkUnloadTaskIdMap.containsKey(chunk) || !this.changedChunks.contains(chunk)) {
            return;
        }
        long start = System.currentTimeMillis();
        int id = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.moreStorage, () -> {
            if (this.lastLoadedTime.containsKey(chunk) && this.lastLoadedTime.get(chunk) <= start && !chunk.isLoaded()) {
                this.saveChunk(chunk, true);
                this.changedChunks.remove(chunk);
                this.loadedChunks.remove(chunk);
                this.lastLoadedTime.remove(chunk);
            }
        }, 600L);
        this.chunkUnloadTaskIdMap.put(chunk, id);
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldSave(WorldSaveEvent event) {
        World world = event.getWorld();
        Iterator<Chunk> iterator = this.changedChunks.iterator();
        while (iterator.hasNext()) {
            Chunk chunk = iterator.next();
            if (!chunk.getWorld().equals(world)) continue;
            this.saveChunk(chunk, false);
            this.changedChunks.remove(chunk);
            this.lastLoadedTime.remove(chunk);
            iterator.remove();
        }
    }

    private void saveChunk(Chunk chunk, boolean unload) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.moreStorage, () -> {
            ChunkChestData data = ChunkChestData.fromChunk(chunk, this.moreStorage);
            File dataFolder = this.getDataFolder(chunk.getWorld());
            if (!dataFolder.exists() && !dataFolder.mkdirs()) {
                this.logger.warning("Failed to make " + dataFolder.getAbsolutePath());
            }
            File chestDataFile = this.getChestDataFile(chunk);
            if (data.getChestData().length == 0) {
                if (chestDataFile.exists()) {
                    return;
                }
                if (!chestDataFile.delete()) {
                    this.logger.warning("Failed to delete " + chestDataFile.getAbsolutePath());
                }
            }
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(chestDataFile, false));){
                objectOutputStream.writeObject(data);
            }
            catch (IOException e) {
                this.logger.warning("Failed to save chest data for chunk " + chunk + "!!");
                e.printStackTrace();
            }
            if (unload) {
                this.loadedChunks.remove(chunk);
            }
        });
    }

    private File getDataFolder(World world) {
        return new File(world.getWorldFolder(), DATA_FOLDER);
    }

    private File getChestDataFile(Chunk chunk) {
        return new File(this.getDataFolder(chunk.getWorld()), String.format(CHEST_CHUNK_NAME_FORMAT, chunk.getX(), chunk.getZ()));
    }
}

