/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.recipe.CustomRecipe;
import me.andrew28.morestorage.recipe.ShapedCustomRecipe;
import me.andrew28.morestorage.recipe.ShapelessCustomRecipe;
import me.andrew28.morestorage.util.ItemMetaUtil;
import me.andrew28.morestorage.util.ListUtil;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ChestRecipeListener
extends MoreStorageListener {
    public ChestRecipeListener(MoreStorage moreStorage) {
        super(moreStorage);
    }

    @EventHandler
    public void onCraftPrepare(PrepareItemCraftEvent event) {
        HumanEntity viewer;
        Recipe recipe = event.getRecipe();
        CraftingInventory inventory = event.getInventory();
        if (recipe == null || inventory == null || this.chestsLoader == null || inventory.getType() != InventoryType.WORKBENCH && inventory.getType() != InventoryType.CRAFTING) {
            return;
        }
        ItemStack[] matrix = inventory.getMatrix();
        Optional<CustomChestInfo> customChestOptional = this.chestsLoader.getCustomChestInfo(recipe.getResult());
        if (!customChestOptional.isPresent()) {
            return;
        }
        CustomChestInfo customChestInfo = customChestOptional.get();
        boolean anyMatches = false;
        for (CustomRecipe customRecipe : customChestInfo.getRecipes()) {
            if (customRecipe.getType().equals((Object)CustomRecipe.CustomRecipeType.SHAPED) && recipe instanceof ShapedRecipe) {
                int craftingSize = matrix.length == 4 ? 2 : 3;
                ArrayList squareMatrixList = new ArrayList();
                for (int row = 0; row < craftingSize; ++row) {
                    ArrayList<ItemStack> squareMatrixRow = new ArrayList<ItemStack>();
                    int offset = row * craftingSize;
                    boolean hasNonNull = false;
                    for (int column = 0; column < craftingSize; ++column) {
                        ItemStack itemStack = matrix[offset + column];
                        if (itemStack != null) {
                            hasNonNull = true;
                        }
                        squareMatrixRow.add(itemStack);
                    }
                    if (!hasNonNull) continue;
                    squareMatrixList.add(squareMatrixRow);
                }
                ItemStack[][] squareMatrix = ListUtil.toArray(squareMatrixList, ItemStack.class, ItemStack[].class);
                ItemStack[][] recipeSquareMatrix = ((ShapedCustomRecipe)customRecipe).getMatrix();
                boolean matches = true;
                block3: for (int index = 0; index < squareMatrix.length; ++index) {
                    ItemStack[] craftRow = squareMatrix[index];
                    ItemStack[] recipeRow = recipeSquareMatrix[index];
                    if (craftRow.length != recipeRow.length) {
                        matches = false;
                        break;
                    }
                    for (int innerIndex = 0; innerIndex < craftRow.length; ++innerIndex) {
                        if (ItemMetaUtil.checkBasicMetaMatches(recipeRow[innerIndex], craftRow[innerIndex])) continue;
                        matches = false;
                        break block3;
                    }
                }
                if (!matches) continue;
                anyMatches = true;
                break;
            }
            if (!customRecipe.getType().equals((Object)CustomRecipe.CustomRecipeType.SHAPELESS) || !(recipe instanceof ShapelessRecipe)) continue;
            ItemStack[] customRecipeItems = ((ShapelessCustomRecipe)customRecipe).getItemStacks();
            if (Arrays.asList(matrix).containsAll(Arrays.asList(customRecipeItems))) {
                anyMatches = true;
                break;
            }
            boolean containsAllItems = true;
            for (ItemStack recipeItem : customRecipeItems) {
                boolean matches = false;
                for (ItemStack craftingItem : matrix) {
                    if (!ItemMetaUtil.checkBasicMetaMatches(recipeItem, craftingItem)) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                containsAllItems = false;
                break;
            }
            if (!containsAllItems) continue;
            anyMatches = true;
            break;
        }
        if (!anyMatches) {
            this.cancel(event);
            return;
        }
        List viewers = event.getViewers();
        String permission = customChestInfo.getPermission();
        if (permission != null && viewers.size() >= 1 && !(viewer = (HumanEntity)viewers.get(0)).hasPermission(permission)) {
            this.cancel(event);
        }
    }

    private void cancel(PrepareItemCraftEvent event) {
        event.getInventory().setResult(null);
    }
}

