/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.util.Optional;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.ChestIdMetadataValue;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.event.CustomChestPlaceEvent;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.metadata.MetadataValue;

public class ChestPlaceListener
extends MoreStorageListener {
    private static final String NO_PERMISSION_MSG_FORMAT = ChatColor.RED + "You do not have sufficient permissions to place down the chest %s";
    private WorldChunkListener worldChunkListener;

    public ChestPlaceListener(MoreStorage moreStorage, WorldChunkListener worldChunkListener) {
        super(moreStorage);
        this.worldChunkListener = worldChunkListener;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Material thisMaterial;
        if (!event.canBuild()) {
            return;
        }
        Optional<CustomChestInfo> chestOptional = this.chestsLoader.getCustomChestInfo(event.getItemInHand());
        if (!chestOptional.isPresent()) {
            return;
        }
        CustomChestInfo chestInfo = chestOptional.get();
        Player player = event.getPlayer();
        String permission = chestInfo.getPermission();
        if (permission != null && !permission.isEmpty() && !player.hasPermission(permission)) {
            event.setCancelled(true);
            player.sendMessage(String.format(NO_PERMISSION_MSG_FORMAT, chestInfo.getName()));
            return;
        }
        Block block = event.getBlock();
        if (!chestInfo.isAllowDoubling() && (thisMaterial = chestInfo.getItemStack().getType()) != null && thisMaterial.name().toLowerCase().contains("chest")) {
            for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                Block relativeBlock = block.getRelative(face);
                if (relativeBlock == null || relativeBlock.getType() != thisMaterial && this.chestLocationMap.get(relativeBlock.getLocation()) == null) continue;
                event.setCancelled(true);
                return;
            }
        }
        CustomChest chest = chestInfo.createChest(event.getBlock());
        CustomChestPlaceEvent customEvent = new CustomChestPlaceEvent(player, chest);
        this.moreStorage.getServer().getPluginManager().callEvent((Event)customEvent);
        if (customEvent.isCancelled()) {
            return;
        }
        Location location = block.getLocation();
        block.setMetadata("chest_id", (MetadataValue)new ChestIdMetadataValue(this.moreStorage, block));
        this.chestLocationMap.put(location, chest);
        chest.startHopperTaskIfNeeded(this.moreStorage);
        this.worldChunkListener.loadedChunks.add(location.getChunk());
        this.worldChunkListener.changedChunks.add(location.getChunk());
    }
}

