/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.util.Iterator;
import java.util.Optional;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.chest.CustomChestInventoryHolder;
import me.andrew28.morestorage.chest.ItemFilter;
import me.andrew28.morestorage.event.CustomChestInventoryCloseEvent;
import me.andrew28.morestorage.event.CustomChestInventoryEvent;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ChestOpenCloseUseListener
extends MoreStorageListener {
    private WorldChunkListener worldChunkListener;

    public ChestOpenCloseUseListener(MoreStorage moreStorage, WorldChunkListener worldChunkListener) {
        super(moreStorage);
        this.worldChunkListener = worldChunkListener;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        Block blockAbove;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = block.getLocation();
        CustomChest chest = (CustomChest)this.chestLocationMap.get(location);
        if (chest == null) {
            return;
        }
        CustomChestInfo info = chest.getInfo();
        Player player = event.getPlayer();
        if (player.isSneaking()) {
            event.setUseItemInHand(Event.Result.ALLOW);
            event.setUseInteractedBlock(Event.Result.DENY);
            return;
        }
        event.setCancelled(true);
        if (info.isRequireTopClearance() && (blockAbove = chest.getBlock().getRelative(BlockFace.UP)) != null && blockAbove.getType().isOccluding()) {
            return;
        }
        CustomChestInventoryEvent customEvent = new CustomChestInventoryEvent(chest, chest.getInventory());
        this.moreStorage.getServer().getPluginManager().callEvent((Event)customEvent);
        if (customEvent.isCancelled()) {
            return;
        }
        this.worldChunkListener.changedChunks.add(location.getChunk());
        try {
            this.moreStorage.getEffectUtil().changeChestOpenState(block, true);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.moreStorage, () -> player.openInventory(chest.getInventory()), 1L);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        CustomChest chest = this.getChest(inventory);
        if (chest == null) {
            return;
        }
        if (inventory.getViewers().size() == 1) {
            Player player = (Player)inventory.getViewers().get(0);
            CustomChestInventoryCloseEvent customEvent = new CustomChestInventoryCloseEvent(chest, inventory);
            this.moreStorage.getServer().getPluginManager().callEvent((Event)customEvent);
            if (customEvent.isCancelled()) {
                return;
            }
            Block block = chest.getBlock();
            World world = block.getWorld();
            world.playSound(block.getLocation(), Sound.BLOCK_CHEST_CLOSE, 1.0f, 1.0f);
            try {
                this.moreStorage.getEffectUtil().changeChestOpenState(block, false);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int firstBannedSlot;
        int bannedSlotAmount;
        int slot = event.getSlot();
        Inventory inventory = event.getClickedInventory();
        CustomChest chest = this.getChest(inventory);
        if (chest == null) {
            return;
        }
        CustomChestInfo info = chest.getInfo();
        ItemFilter itemFilter = info.getItemFilter();
        if (itemFilter != null) {
            ItemStack itemStack = null;
            switch (event.getAction()) {
                case PLACE_ALL: 
                case PLACE_SOME: 
                case SWAP_WITH_CURSOR: {
                    itemStack = event.getCursor();
                    break;
                }
                case HOTBAR_SWAP: {
                    itemStack = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                }
            }
            if (itemStack != null && !itemFilter.canPass(itemStack.getType())) {
                event.setCancelled(true);
                return;
            }
        }
        if (info.getSizeType() == CustomChestInfo.SizeType.SLOTS && (bannedSlotAmount = info.getRequiredRows() * 9 - info.getSize()) > 0 && slot >= (firstBannedSlot = inventory.getSize() - bannedSlotAmount)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        int bannedSlotAmount;
        Inventory inventory = event.getInventory();
        if (inventory == null) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof CustomChestInventoryHolder)) {
            return;
        }
        CustomChest chest = ((CustomChestInventoryHolder)holder).getCustomChest();
        if (chest == null) {
            return;
        }
        CustomChestInfo info = chest.getInfo();
        Optional<Integer> slotOptional = event.getRawSlots().stream().filter(i -> i <= inventory.getSize() - 1).findAny();
        if (!slotOptional.isPresent()) {
            return;
        }
        ItemFilter filter = info.getItemFilter();
        if (filter != null) {
            for (ItemStack itemStack : event.getNewItems().values()) {
                if (filter.canPass(itemStack.getType())) continue;
                event.setCancelled(true);
                return;
            }
        }
        if (info.getSizeType() == CustomChestInfo.SizeType.SLOTS && (bannedSlotAmount = info.getRequiredRows() * 9 - info.getSize()) > 0) {
            int firstBannedSlot = inventory.getSize() - bannedSlotAmount;
            int lastChestSlot = inventory.getSize() - 1;
            Iterator iterator = event.getInventorySlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot > lastChestSlot || slot < firstBannedSlot) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onMoveItemEvent(InventoryClickEvent event) {
        if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY || !(event.getClickedInventory() instanceof PlayerInventory)) {
            return;
        }
        Inventory inventory = event.getWhoClicked().getOpenInventory().getTopInventory();
        int size = inventory.getSize();
        if (size % 9 != 0) {
            return;
        }
        Inventory clone = Bukkit.createInventory(null, (int)size);
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            clone.setItem(slot, inventory.getItem(slot));
        }
        CustomChest chest = this.getChest(inventory);
        if (chest == null) {
            return;
        }
        CustomChestInfo info = chest.getInfo();
        ItemStack currentItem = event.getCurrentItem();
        ItemFilter itemFilter = info.getItemFilter();
        if (itemFilter != null && !itemFilter.canPass(currentItem.getType())) {
            event.setCancelled(true);
            return;
        }
        if (info.getSizeType() == CustomChestInfo.SizeType.SLOTS) {
            int firstBannedSlot;
            clone.addItem(new ItemStack[]{currentItem});
            int bannedSlotAmount = info.getRequiredRows() * 9 - info.getSize();
            for (int slot = firstBannedSlot = inventory.getSize() - bannedSlotAmount; slot < clone.getSize(); ++slot) {
                if (clone.getItem(slot) == null) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    private CustomChest getChest(Inventory inventory) {
        if (inventory == null) {
            return null;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof CustomChestInventoryHolder)) {
            return null;
        }
        return ((CustomChestInventoryHolder)holder).getCustomChest();
    }
}

