/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInventoryHolder;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.InventoryHolder;

public class ChestHopperListener
extends MoreStorageListener {
    public ChestHopperListener(MoreStorage moreStorage) {
        super(moreStorage);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.HOPPER) {
            return;
        }
        for (BlockFace face : BlockFace.values()) {
            Block targetBlock = block.getRelative(face);
            CustomChest chest = this.moreStorage.getChestMap().get(targetBlock.getLocation());
            if (chest == null) continue;
            chest.startHopperTaskIfNeeded(this.moreStorage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMoveItem(InventoryMoveItemEvent event) {
        InventoryHolder holder = event.getDestination().getHolder();
        if (this.shouldCancelMoveItem(holder)) {
            event.setCancelled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldCancelMoveItem(InventoryHolder holder) {
        if (!(holder instanceof CustomChestInventoryHolder)) {
            if (holder instanceof Chest) {
                Chest chest = (Chest)holder;
                Block block = chest.getBlock();
                CustomChest customChest = this.moreStorage.getChestMap().get(block.getLocation());
                if (customChest == null) return false;
                return true;
            }
            if (!(holder instanceof DoubleChest)) return false;
            DoubleChest chest = (DoubleChest)holder;
            if (this.shouldCancelMoveItem(chest.getLeftSide())) return true;
            if (!this.shouldCancelMoveItem(chest.getRightSide())) return false;
            return true;
        }
        CustomChestInventoryHolder customHolder = (CustomChestInventoryHolder)holder;
        if (!customHolder.isItemWasJustInsertedByHopper()) return true;
        customHolder.setItemWasJustInsertedByHopper(false);
        return false;
    }
}

