/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.util.Iterator;
import java.util.List;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.event.CustomChestDestroyEvent;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class ChestExplodeListener
extends MoreStorageListener {
    private WorldChunkListener worldChunkListener;

    public ChestExplodeListener(MoreStorage moreStorage, WorldChunkListener worldChunkListener) {
        super(moreStorage);
        this.worldChunkListener = worldChunkListener;
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    @EventHandler
    public void onExplode(BlockExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    private void handleExplosion(List<Block> blockList) {
        Iterator<Block> blockIterator = blockList.iterator();
        while (blockIterator.hasNext()) {
            Block block = blockIterator.next();
            Location location = block.getLocation();
            CustomChest chest = this.moreStorage.getChestMap().get(location);
            if (chest == null) continue;
            if (chest.getInfo().isBlastProof()) {
                blockIterator.remove();
                continue;
            }
            CustomChestDestroyEvent customEvent = new CustomChestDestroyEvent(chest, CustomChestDestroyEvent.DestroyCause.EXPLOSION);
            this.moreStorage.getServer().getPluginManager().callEvent((Event)customEvent);
            if (customEvent.isCancelled()) {
                blockIterator.remove();
                continue;
            }
            this.moreStorage.getChestMap().remove(location);
            Bukkit.getScheduler().runTaskLater((Plugin)this.moreStorage, () -> chest.destroy(this.worldChunkListener), 1L);
        }
    }
}

