/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.listeners;

import java.util.Map;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.event.CustomChestDestroyEvent;
import me.andrew28.morestorage.listeners.MoreStorageListener;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;

public class ChestDestroyListener
extends MoreStorageListener {
    private WorldChunkListener worldChunkListener;

    public ChestDestroyListener(MoreStorage moreStorage, WorldChunkListener worldChunkListener) {
        super(moreStorage);
        this.worldChunkListener = worldChunkListener;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        Map<Location, CustomChest> chestMap = this.moreStorage.getChestMap();
        CustomChest chest = chestMap.get(location);
        if (chest == null) {
            return;
        }
        CustomChestDestroyEvent customEvent = new CustomChestDestroyEvent(chest, CustomChestDestroyEvent.DestroyCause.BLOCK_BREAK);
        this.moreStorage.getServer().getPluginManager().callEvent((Event)customEvent);
        if (customEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        chestMap.remove(location);
        chest.destroy(this.worldChunkListener);
    }
}

