/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.util.Messages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private MoreStorage moreStorage;
    private Messages messages;

    public MainCommand(MoreStorage moreStorage) {
        this.moreStorage = moreStorage;
        this.messages = moreStorage.getMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String mainArgument;
        Messages.Replacer labelReplacer = new Messages.Replacer("%label", label);
        if (args.length == 0 || args[0].equals("help")) {
            this.messages.send(sender, "commands.main.help", labelReplacer, new Messages.Replacer("%version", this.moreStorage.getDescription().getVersion()));
            return true;
        }
        switch (mainArgument = args[0]) {
            case "reload": {
                try {
                    this.moreStorage.reloadAll();
                    this.messages.send(sender, "commands.main.reload.success", new Messages.Replacer[0]);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.messages.send(sender, "commands.main.reload.fail", new Messages.Replacer[0]);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            List<String> options = Arrays.asList("help", "reload");
            ArrayList<String> completions = new ArrayList();
            if (args[0] == null || args[0].isEmpty()) {
                completions = options;
            } else {
                StringUtil.copyPartialMatches((String)args[0], options, completions);
            }
            return completions;
        }
        return null;
    }
}

