/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.chest;

import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.chest.CustomChestInventoryHolder;
import me.andrew28.morestorage.chest.ItemFilter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Hopper;

class HopperRunnable
implements Runnable {
    private CustomChest chest;
    private MoreStorage moreStorage;
    private Block block;
    private Inventory inventory;

    HopperRunnable(CustomChest chest, MoreStorage moreStorage) {
        this.chest = chest;
        this.moreStorage = moreStorage;
        this.block = chest.getBlock();
        this.inventory = chest.getInventory();
    }

    @Override
    public void run() {
        if (!(this.chest.isRunning() && this.isTouchingHopper() && this.moreStorage.isSupportHoppers())) {
            this.chest.hopperTask.cancel();
            this.chest.hopperTask = null;
            return;
        }
        this.checkInsert();
        this.checkRemove();
    }

    private boolean isTouchingHopper() {
        for (BlockFace face : new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            if (this.block.getRelative(face).getType() != Material.HOPPER) continue;
            return true;
        }
        return false;
    }

    private void checkInsert() {
        block0: for (BlockFace face : new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.UP}) {
            Block hopperBlock = this.block.getRelative(face);
            if (hopperBlock.getType() != Material.HOPPER || hopperBlock.isBlockPowered() || hopperBlock.isBlockIndirectlyPowered()) continue;
            org.bukkit.block.Hopper hopper = (org.bukkit.block.Hopper)hopperBlock.getState();
            Inventory hopperInventory = hopper.getInventory();
            Hopper hopperData = (Hopper)hopperBlock.getState().getData();
            if (hopperData.getFacing() != face.getOppositeFace()) continue;
            for (int hopperSlot = hopperInventory.getSize() - 1; hopperSlot > -1; --hopperSlot) {
                ItemStack currentItem = hopperInventory.getItem(hopperSlot);
                if (currentItem == null) continue;
                ItemStack itemToAdd = currentItem.clone();
                itemToAdd.setAmount(1);
                ItemFilter itemFilter = this.chest.getInfo().getItemFilter();
                if (itemFilter != null && !itemFilter.canPass(itemToAdd.getType())) continue;
                CustomChestInfo info = this.chest.getInfo();
                if (info.getSizeType() == CustomChestInfo.SizeType.SLOTS) {
                    int firstBannedSlot;
                    Inventory clone = Bukkit.createInventory(null, (int)this.inventory.getSize());
                    for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
                        clone.setItem(slot, this.inventory.getItem(slot));
                    }
                    clone.addItem(new ItemStack[]{currentItem});
                    int bannedSlotAmount = info.getRequiredRows() * 9 - info.getSize();
                    for (int slot = firstBannedSlot = this.inventory.getSize() - bannedSlotAmount; slot < clone.getSize(); ++slot) {
                        if (clone.getItem(slot) == null) continue;
                        return;
                    }
                }
                ((CustomChestInventoryHolder)this.inventory.getHolder()).setItemWasJustInsertedByHopper(true);
                InventoryMoveItemEvent event = new InventoryMoveItemEvent(hopperInventory, itemToAdd, hopperInventory, true);
                this.moreStorage.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (this.inventory.addItem(new ItemStack[]{itemToAdd}).size() != 0) continue block0;
                if (currentItem.getAmount() == 1) {
                    hopperInventory.setItem(hopperSlot, null);
                    continue block0;
                }
                currentItem.setAmount(currentItem.getAmount() - 1);
                continue block0;
            }
        }
    }

    private void checkRemove() {
        Block blockBelow = this.block.getRelative(BlockFace.DOWN);
        if (blockBelow.getType() != Material.HOPPER || blockBelow.isBlockPowered() || blockBelow.isBlockIndirectlyPowered()) {
            return;
        }
        org.bukkit.block.Hopper hopper = (org.bukkit.block.Hopper)blockBelow.getState();
        Inventory hopperInventory = hopper.getInventory();
        ItemStack[] contents = this.inventory.getContents();
        for (int slot = contents.length - 1; slot > -1; --slot) {
            ItemStack currentItem = contents[slot];
            if (currentItem == null) continue;
            ItemStack itemToAdd = currentItem.clone();
            itemToAdd.setAmount(1);
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(this.inventory, itemToAdd, hopperInventory, false);
            this.moreStorage.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (hopperInventory.addItem(new ItemStack[]{itemToAdd}).size() != 0) break;
            if (currentItem.getAmount() == 1) {
                this.inventory.setItem(slot, null);
                break;
            }
            currentItem.setAmount(currentItem.getAmount() - 1);
            break;
        }
    }
}

