/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.chest;

import java.util.List;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInventoryHolder;
import me.andrew28.morestorage.chest.ItemFilter;
import me.andrew28.morestorage.recipe.CustomRecipe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CustomChestInfo {
    private static final int SLOTS_IN_A_ROW = 9;
    private String id;
    private String name;
    private String permission;
    private ItemStack itemStack;
    private SizeType sizeType;
    private int size;
    private List<CustomRecipe> recipes;
    private boolean blastProof = false;
    private ItemFilter itemFilter;
    private boolean requireTopClearance;
    private boolean allowHoppers;
    private boolean allowDoubling = true;

    public CustomChestInfo(String id, String name, String permission, ItemStack itemStack, SizeType sizeType, int size, List<CustomRecipe> recipes) {
        this.id = id;
        this.name = name;
        this.permission = permission;
        this.itemStack = itemStack;
        this.sizeType = sizeType;
        this.size = size;
        this.recipes = recipes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public ItemStack getItemStack() {
        if (this.itemStack == null) {
            return null;
        }
        return this.itemStack.clone();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public SizeType getSizeType() {
        return this.sizeType;
    }

    public void setSizeType(SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public void setSize(int size, SizeType sizeType) {
        this.size = size;
        this.sizeType = sizeType;
    }

    public int getRequiredRows() {
        return this.sizeType == SizeType.SLOTS ? (int)Math.ceil((double)this.size / 9.0) : this.size;
    }

    public int getSlots() {
        return this.sizeType == SizeType.SLOTS ? this.size : this.size * 9;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<CustomRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean isBlastProof() {
        return this.blastProof;
    }

    public void setBlastProof(boolean blastProof) {
        this.blastProof = blastProof;
    }

    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public void setItemFilter(ItemFilter itemFilter) {
        this.itemFilter = itemFilter;
    }

    public boolean isRequireTopClearance() {
        return this.requireTopClearance;
    }

    public void setRequireTopClearance(boolean requireTopClearance) {
        this.requireTopClearance = requireTopClearance;
    }

    public boolean isAllowHoppers() {
        return this.allowHoppers;
    }

    public void setAllowHoppers(boolean allowHoppers) {
        this.allowHoppers = allowHoppers;
    }

    public boolean isAllowDoubling() {
        return this.allowDoubling;
    }

    public void setAllowDoubling(boolean allowDoubling) {
        this.allowDoubling = allowDoubling;
    }

    public Inventory createInventory(CustomChest customChest) {
        CustomChestInventoryHolder inventoryHolder = new CustomChestInventoryHolder(customChest);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)inventoryHolder, (int)(this.getRequiredRows() * 9), (String)this.name);
        inventoryHolder.setInventory(inventory);
        return inventory;
    }

    public CustomChest createChest(Block block) {
        CustomChest customChest = new CustomChest(this, block, null);
        customChest.setInventory(this.createInventory(customChest));
        return customChest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomChestInfo)) {
            return false;
        }
        CustomChestInfo chest = (CustomChestInfo)o;
        return new EqualsBuilder().append(this.size, chest.size).append(this.blastProof, chest.blastProof).append((Object)this.id, (Object)chest.id).append((Object)this.name, (Object)chest.name).append((Object)this.permission, (Object)chest.permission).append((Object)this.sizeType, (Object)chest.sizeType).append(this.recipes, chest.recipes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.permission).append((Object)this.sizeType).append(this.size).append(this.recipes).append(this.blastProof).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("permission", (Object)this.permission).append("sizeType", (Object)this.sizeType).append("size", this.size).append("recipes", this.recipes).append("blastProof", this.blastProof).toString();
    }

    public static enum SizeType {
        SLOTS,
        ROWS;

    }
}

