/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage.chest;

import java.util.Arrays;
import java.util.Objects;
import me.andrew28.morestorage.MoreStorage;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.chest.HopperRunnable;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CustomChest {
    protected BukkitTask hopperTask;
    private CustomChestInfo info;
    private Block block;
    private Inventory inventory;
    private boolean running = true;

    CustomChest(CustomChestInfo info, Block block, Inventory inventory) {
        this.info = info;
        this.block = block;
        this.inventory = inventory;
    }

    public CustomChestInfo getInfo() {
        return this.info;
    }

    public void setInfo(CustomChestInfo info) {
        this.info = info;
        ItemStack[] oldContents = this.inventory.getContents();
        this.inventory = info.createInventory(this);
        int lastSlot = oldContents.length;
        if (info.getSizeType() == CustomChestInfo.SizeType.SLOTS) {
            int bannedSlotAmount = info.getRequiredRows() * 9 - info.getSize();
            lastSlot = this.inventory.getSize() - bannedSlotAmount - 1;
        }
        for (int slot = 0; slot < lastSlot; ++slot) {
            this.inventory.setItem(slot, oldContents[slot]);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void destroy(WorldChunkListener worldChunkListener) {
        this.running = false;
        Location location = this.block.getLocation();
        worldChunkListener.changedChunks.add(location.getChunk());
        if (this.inventory != null) {
            Arrays.stream(this.inventory.getContents()).filter(Objects::nonNull).filter(itemStack -> itemStack.getType() != Material.AIR).forEach(itemStack -> location.getWorld().dropItemNaturally(location, itemStack));
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startHopperTaskIfNeeded(MoreStorage moreStorage) {
        if (!this.info.isAllowHoppers()) {
            return;
        }
        if (this.hopperTask != null) {
            return;
        }
        this.hopperTask = Bukkit.getScheduler().runTaskTimer((Plugin)moreStorage, (Runnable)new HopperRunnable(this, moreStorage), 0L, (long)moreStorage.getHopperSpeed());
    }
}

