/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.morestorage;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import me.andrew28.morestorage.ChestsLoader;
import me.andrew28.morestorage.chest.CustomChest;
import me.andrew28.morestorage.chest.CustomChestInfo;
import me.andrew28.morestorage.command.ChestCommand;
import me.andrew28.morestorage.command.MainCommand;
import me.andrew28.morestorage.listeners.ChestDestroyListener;
import me.andrew28.morestorage.listeners.ChestExplodeListener;
import me.andrew28.morestorage.listeners.ChestHopperListener;
import me.andrew28.morestorage.listeners.ChestOpenCloseUseListener;
import me.andrew28.morestorage.listeners.ChestPlaceListener;
import me.andrew28.morestorage.listeners.ChestRecipeListener;
import me.andrew28.morestorage.listeners.WorldChunkListener;
import me.andrew28.morestorage.org.bstats.bukkit.Metrics;
import me.andrew28.morestorage.util.EffectUtil;
import me.andrew28.morestorage.util.ItemUtil;
import me.andrew28.morestorage.util.Messages;
import me.andrew28.morestorage.util.NBTUtil;
import me.andrew28.morestorage.util.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MoreStorage
extends JavaPlugin {
    private ReflectionUtil reflectionUtil;
    private NBTUtil nbtUtil;
    private ItemUtil itemUtil;
    private EffectUtil effectUtil;
    private boolean resetRecipes;
    private boolean supportHoppers;
    private int hopperSpeed;
    private File chestsFile = new File(this.getDataFolder(), "chests.yml");
    private ChestsLoader chestsLoader;
    private Map<Location, CustomChest> chestMap = new ConcurrentHashMap<Location, CustomChest>();
    private File messagesFile = new File(this.getDataFolder(), "messages.yml");
    private Messages messages;

    public void onEnable() {
        String serverVersion = this.getServer().getClass().getPackage().getName().split("\\.")[3];
        this.getLogger().info("Detected NMS version: " + serverVersion);
        this.reflectionUtil = new ReflectionUtil(serverVersion);
        try {
            this.nbtUtil = new NBTUtil(this.reflectionUtil);
            this.itemUtil = new ItemUtil(this.nbtUtil);
            this.effectUtil = new EffectUtil(this.reflectionUtil);
        }
        catch (ReflectiveOperationException e) {
            this.disable("Failed to initialize NMS", e);
            return;
        }
        this.saveDefaultConfig();
        this.readConfig();
        if (!this.chestsFile.exists()) {
            this.saveResource("chests.yml", false);
        }
        this.chestsLoader = new ChestsLoader(this.chestsFile, this);
        this.chestsLoader.load();
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = new Messages(this.messagesFile);
        this.messages.load();
        this.registerListeners();
        this.getCommand("morestorage").setExecutor((CommandExecutor)new MainCommand(this));
        this.getCommand("customchest").setExecutor((CommandExecutor)new ChestCommand(this));
        new Metrics(this);
    }

    private void reloadChests() {
        this.chestsLoader.load();
    }

    private void reloadMessages() {
        this.messages.load();
    }

    private void readConfig() {
        this.reloadConfig();
        this.resetRecipes = this.getConfig().getBoolean("reset-recipes", false);
        this.supportHoppers = this.getConfig().getBoolean("hopper-support", true);
        this.hopperSpeed = this.getConfig().getInt("hopper-speed", 8);
    }

    private void redoChests() {
        this.chestMap.values().forEach(chest -> {
            chest.startHopperTaskIfNeeded(this);
            String id = chest.getInfo().getId();
            Optional<CustomChestInfo> infoOptional = this.chestsLoader.getCustomChestInfoById(id);
            if (!infoOptional.isPresent()) {
                return;
            }
            chest.setInfo(infoOptional.get());
        });
    }

    public void reloadAll() {
        this.reloadChests();
        this.reloadMessages();
        this.readConfig();
        this.redoChests();
    }

    private void registerListeners() {
        WorldChunkListener worldChunkListener = new WorldChunkListener(this);
        this.registerListeners(new ChestRecipeListener(this), new ChestPlaceListener(this, worldChunkListener), new ChestOpenCloseUseListener(this, worldChunkListener), worldChunkListener, new ChestDestroyListener(this, worldChunkListener), new ChestExplodeListener(this, worldChunkListener), new ChestHopperListener(this));
    }

    private void registerListeners(Listener ... listeners) {
        for (Listener listener : listeners) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    private void disable(String message, Throwable throwable) {
        if (message != null) {
            if (throwable != null) {
                this.getLogger().log(Level.SEVERE, message, throwable);
            } else {
                this.getLogger().log(Level.SEVERE, message);
            }
        }
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    public NBTUtil getNbtUtil() {
        return this.nbtUtil;
    }

    public ItemUtil getItemUtil() {
        return this.itemUtil;
    }

    public EffectUtil getEffectUtil() {
        return this.effectUtil;
    }

    public ChestsLoader getChestsLoader() {
        return this.chestsLoader;
    }

    public Map<Location, CustomChest> getChestMap() {
        return this.chestMap;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public boolean isResetRecipes() {
        return this.resetRecipes;
    }

    public boolean isSupportHoppers() {
        return this.supportHoppers;
    }

    public int getHopperSpeed() {
        return this.hopperSpeed;
    }
}

