/*
 * Decompiled with CFR 0.152.
 */
package me.MartiFuture.MoreMobHeads;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import me.MartiFuture.MoreMobHeads.ImgMessage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MoreMobHeads
extends JavaPlugin
implements Listener {
    Map<String, String> mobs = new HashMap<String, String>();

    public void onEnable() {
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        if (!new File(this.getDataFolder(), "Information.txt").exists()) {
            this.saveDefaultConfig();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getConfig().getBoolean("useCloudFile")) {
            try {
                String inputLine;
                URL mobSkins = new URL(this.getConfig().getString("headFileURL"));
                BufferedReader in = new BufferedReader(new InputStreamReader(mobSkins.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    String[] line = inputLine.split(",");
                    this.mobs.put(line[0], line[1]);
                }
                System.out.println("[MoreMobHeads] Heads file in the cloud has been successfully loaded!");
                in.close();
            }
            catch (Exception e) {
                System.out.println("[MoreMobHeads] Heads file in the cloud hasn't loaded. Are you sure you have an active internet connection?");
                System.out.println("[MoreMobHeads] Cannot reach Cloud File... Will load head from flat file.");
                this.bootFromFlatFile();
            }
        } else {
            System.out.println("[MoreMobHeads] Cloud Head File is disabled... Will load head from flat file.");
            this.bootFromFlatFile();
        }
    }

    private void bootFromFlatFile() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResource("mobHeadFlatFile.txt")));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                this.mobs.put(parts[0], parts[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("mmh")) {
            sender.sendMessage(ChatColor.RED + "MoreMobHeads-2 Commands:");
            sender.sendMessage(ChatColor.BLUE + "/mmh help (All commands and permission");
        } else {
            sender.sendMessage(ChatColor.RED + "WARNG: " + ChatColor.BLUE + "Use /mmh help");
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("list")) {
                    sender.sendMessage(ChatColor.BOLD + ChatColor.STRIKETHROUGH + ChatColor.BLUE + "-------------------" + ChatColor.YELLOW + "---------------" + ChatColor.BLUE + "-------------------");
                    sender.sendMessage(ChatColor.GREEN + ChatColor.BOLD + "List of Mobs:");
                    for (String mob : this.mobs.keySet()) {
                        sender.sendMessage(ChatColor.YELLOW + "- " + mob);
                    }
                    sender.sendMessage(ChatColor.BOLD + ChatColor.STRIKETHROUGH + ChatColor.BLUE + "-------------------" + ChatColor.YELLOW + "---------------" + ChatColor.BLUE + "-------------------");
                } else {
                    sender.sendMessage(ChatColor.RED + "WARNG: " + ChatColor.BLUE + "Use /mmh help");
                }
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help")) {
                    sender.sendMessage(ChatColor.BOLD + ChatColor.STRIKETHROUGH + ChatColor.BLUE + "-------------------" + ChatColor.YELLOW + "---------------" + ChatColor.BLUE + "-------------------");
                    sender.sendMessage(ChatColor.BOLD + ChatColor.GREEN + "MoreMobHeads-2 Commands:");
                    sender.sendMessage(ChatColor.YELLOW + "- /mmh spawnMobHead <mobName> (Spawns the specified mob's head)");
                    sender.sendMessage(ChatColor.YELLOW + "- /mmh spawnPlayerHead <playerName> (Spawns the specified player's head)");
                    sender.sendMessage(ChatColor.YELLOW + "- /mmh list (Lists all the avaibile mob names)");
                    sender.sendMessage(ChatColor.BOLD + ChatColor.RED + "Permission!:");
                    sender.sendMessage(ChatColor.RED + "- MoreMobHeads.SpawnMobHead " + ChatColor.YELLOW + "Permission for spawn mob head)");
                    sender.sendMessage(ChatColor.RED + "- spawnPlayerHead " + ChatColor.YELLOW + "Permission for spawn player head)");
                    sender.sendMessage(ChatColor.BLUE + "Update!:");
                    sender.sendMessage(ChatColor.BLUE + "Pls Update to: www.pvphistory.eu");
                    sender.sendMessage(ChatColor.BOLD + ChatColor.STRIKETHROUGH + ChatColor.BLUE + "-------------------" + ChatColor.YELLOW + "---------------" + ChatColor.BLUE + "-------------------");
                } else {
                    sender.sendMessage(ChatColor.RED + "WARNG:" + ChatColor.RED + "Use /mmh help");
                }
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("spawnMobHead")) {
                    if (sender.hasPermission("MoreMobHeads.SpawnMobHead") || sender.isOp()) {
                        ItemStack head = this.spawnHead(args[1]);
                        if (head == null) {
                            sender.sendMessage(ChatColor.RED + "[MoreMobHeads-2] Invalid mob name!");
                            return true;
                        }
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            player.getInventory().addItem(new ItemStack[]{head});
                            player.sendMessage(ChatColor.GREEN + "[MoreMobHeads] " + args[1] + " Head Spawned!");
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED + "[MoreMobHeads-2] You don't have permission for this task!");
                    }
                } else if (args[0].equalsIgnoreCase("spawnPlayerHead")) {
                    if (!(sender instanceof Player)) {
                        return true;
                    }
                    if (sender.hasPermission("MoreMobHeads.SpawnPlayerHead") || sender.isOp()) {
                        Player player = (Player)sender;
                        ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, 3);
                        SkullMeta sm = (SkullMeta)head.getItemMeta();
                        sm.setOwner(args[1]);
                        if (this.getConfig().getBoolean("getLoreHead")) {
                            String[] lines = null;
                            try {
                                BufferedImage image = (BufferedImage)this.getImage(args[1]);
                                BufferedImage simage = image.getSubimage(8, 8, 8, 8);
                                ChatColor[][] colors = ImgMessage.toChatColorArray(simage, 8);
                                lines = ImgMessage.toImgMessage(colors, ImgMessage.ImgChar.MEDIUM_SHADE.getChar());
                                sm.setLore(Arrays.asList(lines));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        head.setItemMeta((ItemMeta)sm);
                        player.getInventory().addItem(new ItemStack[]{head});
                        player.sendMessage(ChatColor.GREEN + "[MoreMobHeads-2] You spawned " + args[1] + "'s Head!");
                    } else {
                        sender.sendMessage(ChatColor.RED + "[MoreMobHeads-2] You don't have permission for this task!");
                    }
                }
            }
        }
        return true;
    }

    public Image getImage(String name) {
        BufferedImage image = null;
        try {
            URL url = new URL("http://skins.minecraft.net/MinecraftSkins/" + name + ".png");
            image = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public ItemStack spawnHead(String mobName) {
        if (this.mobs.containsKey(mobName)) {
            for (String mob : this.mobs.keySet()) {
                if (!mobName.toLowerCase().equalsIgnoreCase(mob.toLowerCase())) continue;
                ItemStack item = new ItemStack(Material.SKULL_ITEM, 1, 3);
                SkullMeta sm = (SkullMeta)item.getItemMeta();
                sm.setDisplayName(ChatColor.RESET + mobName + " Head");
                sm.setOwner(this.mobs.get(mob));
                if (this.getConfig().getBoolean("getLoreHead")) {
                    BufferedImage image = (BufferedImage)this.getImage(this.mobs.get(mob));
                    BufferedImage simage = image.getSubimage(8, 8, 8, 8);
                    ChatColor[][] colors = ImgMessage.toChatColorArray(simage, 8);
                    String[] lines = ImgMessage.toImgMessage(colors, ImgMessage.ImgChar.MEDIUM_SHADE.getChar());
                    sm.setLore(Arrays.asList(lines));
                }
                item.setItemMeta((ItemMeta)sm);
                return item;
            }
        }
        return null;
    }

    @EventHandler
    public void death(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            int fact;
            Random rand;
            int chance;
            String entityName = event.getEntityType().getName();
            if (this.mobs.containsKey(entityName) && this.getConfig().getBoolean("Drops.MobHeads.Enabled")) {
                chance = this.getConfig().getInt("Drops.MobHeads.Chance");
                rand = new Random();
                fact = rand.nextInt(101);
                if (fact <= chance) {
                    ItemStack head = this.spawnHead(entityName);
                    event.getDrops().add(head);
                }
            }
            if ((event.getEntity().getType() == EntityType.CREEPER || event.getEntity().getType() == EntityType.SKELETON || event.getEntity().getType() == EntityType.ZOMBIE || event.getEntity().getType() == EntityType.WITHER) && this.getConfig().getBoolean("Drops.MobHeads.Enabled")) {
                chance = this.getConfig().getInt("Drops.MobHeads.Chance");
                rand = new Random();
                fact = rand.nextInt(101);
                if (fact <= chance) {
                    short damage = 0;
                    switch (event.getEntity().getType()) {
                        case CREEPER: {
                            damage = 4;
                            break;
                        }
                        case ZOMBIE: {
                            damage = 2;
                            break;
                        }
                        case WITHER: {
                            damage = 1;
                        }
                    }
                    ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, damage);
                    event.getDrops().add(head);
                }
            }
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent event) {
        if (this.getConfig().getBoolean("Drops.PlayerHeads.Enabled")) {
            int chance = this.getConfig().getInt("Drops.PlayerHeads.Chance");
            Random rand = new Random();
            int fact = rand.nextInt(101);
            if (fact <= chance) {
                ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, 3);
                SkullMeta sm = (SkullMeta)head.getItemMeta();
                sm.setOwner(event.getEntity().getName());
                if (this.getConfig().getBoolean("getLoreHead")) {
                    String[] lines = null;
                    try {
                        BufferedImage image = (BufferedImage)this.getImage(event.getEntity().getName());
                        BufferedImage simage = image.getSubimage(8, 8, 8, 8);
                        ChatColor[][] colors = ImgMessage.toChatColorArray(simage, 8);
                        lines = ImgMessage.toImgMessage(colors, ImgMessage.ImgChar.MEDIUM_SHADE.getChar());
                        sm.setLore(Arrays.asList(lines));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                head.setItemMeta((ItemMeta)sm);
                event.getDrops().add(head);
            }
        }
    }
}

