/*
 * Decompiled with CFR 0.152.
 */
package me.MartiFuture.MoreMobHeads;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ImgMessage {
    public static HashMap<Color, ChatColor> colorMap = new HashMap<Color, ChatColor>(){
        {
            this.put(new Color(0, 0, 0), ChatColor.BLACK);
            this.put(new Color(0, 0, 170), ChatColor.DARK_BLUE);
            this.put(new Color(0, 170, 0), ChatColor.DARK_GREEN);
            this.put(new Color(0, 170, 170), ChatColor.DARK_AQUA);
            this.put(new Color(170, 0, 0), ChatColor.DARK_RED);
            this.put(new Color(170, 0, 170), ChatColor.DARK_PURPLE);
            this.put(new Color(255, 170, 0), ChatColor.GOLD);
            this.put(new Color(170, 170, 170), ChatColor.GRAY);
            this.put(new Color(85, 85, 85), ChatColor.DARK_GRAY);
            this.put(new Color(85, 85, 255), ChatColor.BLUE);
            this.put(new Color(85, 255, 85), ChatColor.GREEN);
            this.put(new Color(85, 255, 255), ChatColor.AQUA);
            this.put(new Color(255, 85, 85), ChatColor.RED);
            this.put(new Color(255, 85, 255), ChatColor.LIGHT_PURPLE);
            this.put(new Color(255, 255, 85), ChatColor.YELLOW);
            this.put(new Color(255, 255, 255), ChatColor.WHITE);
        }
    };

    public static ChatColor[][] toChatColorArray(BufferedImage image, int height) {
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        int width = (int)((double)height / ratio);
        if (width > 10) {
            width = 10;
        }
        BufferedImage resized = ImgMessage.resizeImage(image, (int)((double)height / ratio), height);
        ChatColor[][] chatImg = new ChatColor[resized.getWidth()][resized.getHeight()];
        int x = 0;
        while (x < resized.getWidth()) {
            int y = 0;
            while (y < resized.getHeight()) {
                ChatColor closest;
                int rgb = resized.getRGB(x, y);
                chatImg[x][y] = closest = ImgMessage.getClosestChatColor(new Color(rgb));
                ++y;
            }
            ++x;
        }
        return chatImg;
    }

    public static String[] toImgMessage(ChatColor[][] colors, char imgchar) {
        String[] lines = new String[colors[0].length];
        int y = 0;
        while (y < colors[0].length) {
            String line = "";
            int x = 0;
            while (x < colors.length) {
                line = String.valueOf(line) + colors[x][y].toString() + imgchar;
                ++x;
            }
            lines[y] = String.valueOf(line) + ChatColor.RESET;
            ++y;
        }
        return lines;
    }

    public static String[] appendTextToImg(String[] chatImg, String ... text) {
        int y = 0;
        while (y < chatImg.length) {
            if (text.length > y) {
                chatImg[y] = String.valueOf(chatImg[y]) + " " + text[y];
            }
            ++y;
        }
        return chatImg;
    }

    public static String[] appendCenteredTextToImg(String[] chatImg, String ... text) {
        int y = 0;
        while (y < chatImg.length) {
            if (text.length <= y) {
                return chatImg;
            }
            int len = 65 - chatImg[y].length();
            chatImg[y] = String.valueOf(chatImg[y]) + ImgMessage.center(text[y], len);
            ++y;
        }
        return chatImg;
    }

    public static String center(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        if (s.length() == length) {
            return s;
        }
        int leftPadding = (length - s.length()) / 2;
        StringBuilder leftBuilder = new StringBuilder();
        int i = 0;
        while (i < leftPadding) {
            leftBuilder.append(" ");
            ++i;
        }
        return String.valueOf(leftBuilder.toString()) + s;
    }

    public static void imgMessage(Player player, BufferedImage image, int height, char imgchar, String ... text) {
        ImgMessage.imgMessage(player, image, height, imgchar, true, text);
    }

    public static void imgMessage(Player player, BufferedImage image, int height, char imgchar, boolean centered, String ... text) {
        ChatColor[][] colors = ImgMessage.toChatColorArray(image, height);
        String[] lines = ImgMessage.toImgMessage(colors, imgchar);
        lines = centered ? ImgMessage.appendCenteredTextToImg(lines, text) : ImgMessage.appendTextToImg(lines, text);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            player.sendMessage(line);
            ++n2;
        }
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 6);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }

    private static ChatColor getClosestChatColor(Color c) {
        Integer r = c.getRed();
        Integer g = c.getGreen();
        Integer b = c.getBlue();
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        float h = hsb[0];
        float s = hsb[1];
        float v = hsb[2];
        if ((double)s > 0.4 && (double)v > 0.2 && (double)h < 0.03333333333) {
            return ChatColor.RED;
        }
        if ((double)s > 0.6 && (double)v > 0.7 && (double)h > 0.0333333333 && (double)h < 0.1138888888) {
            return ChatColor.GOLD;
        }
        if ((double)s > 0.4 && (double)v > 0.14 && (double)h > 0.019 && (double)h < 0.15) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.6 && (double)v > 0.09 && (double)h > 0.019 && (double)h < 0.15) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.3 && (double)v > 0.5 && (double)h > 0.02 && (double)h < 0.15) {
            return ChatColor.DARK_RED;
        }
        if ((double)s < 0.41 && (double)v < 0.2 && (double)h > 0.01 && (double)h < 0.15) {
            return ChatColor.BLACK;
        }
        if ((double)s > 0.4 && (double)v < 0.35 && (double)v > 0.2 && (double)h > 0.969) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.4 && (double)v < 0.2 && (double)v > 0.1 && (double)h > 0.079999999 && (double)h < 0.1222222) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.8 && (double)v < 0.15 && (double)v > 0.05 && (double)h > 0.079999999 && (double)h < 0.1222222) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.4 && (double)v > 0.5 && (double)h > 0.1138888888 && (double)h < 0.1916666666) {
            return ChatColor.YELLOW;
        }
        if ((double)s > 0.4 && (double)v < 0.51 && (double)v > 0.1 && (double)h > 0.1138888888 && (double)h < 0.1916666666) {
            return ChatColor.DARK_RED;
        }
        if ((double)s > 0.4 && (double)v > 0.2 && (double)v < 0.81 && (double)h > 0.1916666666 && (double)h < 0.3805555555) {
            return ChatColor.DARK_GREEN;
        }
        if ((double)s > 0.4 && (double)v > 0.5 && (double)h > 0.1916666666 && (double)h < 0.3805555555) {
            return ChatColor.GREEN;
        }
        if ((double)s > 0.2 && (double)v > 0.75 && (double)h > 0.1916666666 && (double)h < 0.3805555555) {
            return ChatColor.GREEN;
        }
        if ((double)s > 0.2 && (double)v > 0.8 && (double)h > 0.3805555555 && (double)h < 0.5194444444) {
            return ChatColor.BLUE;
        }
        if ((double)s > 0.1 && (double)s < 0.21 && (double)v > 0.9 && (double)h > 0.3805555555 && (double)h < 0.5194444444) {
            return ChatColor.BLUE;
        }
        if ((double)s > 0.4 && (double)v < 0.81 && (double)v > 0.2 && (double)h > 0.3805555555 && (double)h < 0.6027777777) {
            return ChatColor.AQUA;
        }
        if ((double)s > 0.4 && (double)v > 0.2 && (double)h > 0.5194444444 && (double)h < 0.6027777777) {
            return ChatColor.AQUA;
        }
        if ((double)s > 0.4 && (double)v > 0.4 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)s > 0.2 && (double)s < 0.41 && (double)v > 0.7 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.BLUE;
        }
        if ((double)s > 0.114 && (double)s < 0.2 && (double)v > 0.6 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)s > 0.1 && (double)s < 0.2 && (double)v > 0.6 && (double)v < 0.91 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.BLUE;
        }
        if ((double)s > 0.114 && (double)s < 0.2 && (double)v > 0.9 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)s > 0.6 && (double)v > 0.1 && (double)h > 0.6027777777 && (double)h < 0.6944444444) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)s > 0.4 && (double)v > 0.3 && (double)h > 0.6944444444 && (double)h < 0.8305555555) {
            return ChatColor.DARK_PURPLE;
        }
        if ((double)s > 0.4 && (double)v > 0.4 && (double)h > 0.8305555555 && (double)h < 0.8777777777) {
            return ChatColor.LIGHT_PURPLE;
        }
        if ((double)s > 0.3 && (double)v > 0.4 && (double)h > 0.8777777777 && (double)h < 0.9611111111) {
            return ChatColor.LIGHT_PURPLE;
        }
        if ((double)s > 0.4 && (double)v > 0.4 && (double)h > 0.9361111111 && (double)h < 1.0000000001) {
            return ChatColor.RED;
        }
        if ((double)s < 0.11 && (double)v > 0.9) {
            return ChatColor.WHITE;
        }
        if ((double)s < 0.11 && (double)v < 0.91 && (double)v > 0.7) {
            return ChatColor.WHITE;
        }
        if ((double)s < 0.11 && (double)v < 0.71 && (double)v > 0.2) {
            return ChatColor.WHITE;
        }
        if ((double)s < 0.11 && (double)v < 0.21) {
            return ChatColor.BLACK;
        }
        if ((double)s < 0.3 && (double)v < 0.3 && (double)v > 0.1) {
            return ChatColor.GRAY;
        }
        if ((double)s < 0.3 && (double)v < 0.11) {
            return ChatColor.BLACK;
        }
        if ((double)s < 0.7 && (double)v < 0.6) {
            return ChatColor.BLACK;
        }
        if ((double)v < 0.1) {
            return ChatColor.BLACK;
        }
        if ((double)s > 0.29 && (double)s < 0.8 && (double)v < 0.11) {
            return ChatColor.GRAY;
        }
        if ((double)s > 0.29 && (double)s < 0.6 && (double)v < 0.2) {
            return ChatColor.GRAY;
        }
        if ((double)s > 0.6 && (double)h > 0.5666666 && (double)h < 0.602777 && (double)v > 0.12 && (double)v < 0.3) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)h > 0.5 && (double)h < 0.602777 && (double)v < 0.13) {
            return ChatColor.BLACK;
        }
        if ((double)h > 0.95833333 && (double)s > 0.7 && (double)v > 0.19 && (double)v < 0.4) {
            return ChatColor.RED;
        }
        if ((double)h > 0.8 && (double)h < 0.91666666 && (double)s > 0.35 && (double)v > 0.16 && (double)v < 0.4) {
            return ChatColor.DARK_PURPLE;
        }
        if ((double)h > 0.3055555 && (double)h < 0.3888888 && (double)s < 0.35 && (double)v > 0.6 && (double)v < 0.8) {
            return ChatColor.AQUA;
        }
        if ((double)h > 0.38 && (double)h < 0.5833333 && (double)s < 0.35 && (double)v > 0.7 && (double)v < 0.95) {
            return ChatColor.BLUE;
        }
        if ((double)h > 0.38 && (double)h < 0.5833333 && (double)s < 0.35 && (double)v > 0.5 && (double)v < 0.71) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)h > 0.5 && (double)h < 0.61 && (double)s > 0.2 && (double)v > 0.7) {
            return ChatColor.BLUE;
        }
        if ((double)h > 0.5 && (double)h < 0.61 && (double)s > 0.2 && (double)v < 0.71) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)s < 0.31 && (double)v < 0.16) {
            return ChatColor.BLACK;
        }
        if ((double)h > 0.32 && (double)h < 0.501 && (double)s > 0.99 && (double)v < 0.12) {
            return ChatColor.BLACK;
        }
        if ((double)h > 0.53 && (double)h < 0.7 && (double)s > 0.5 && (double)v < 0.3 && (double)v > 0.15) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)h > 0.4 && (double)h < 0.53 && (double)s > 0.5 && (double)v < 0.3 && (double)v > 0.15) {
            return ChatColor.AQUA;
        }
        if ((double)h < 0.4 && (double)h > 0.2777777 && (double)s > 0.5 && (double)v < 0.3 && (double)v > 0.15) {
            return ChatColor.DARK_GREEN;
        }
        if ((double)h < 0.25 && (double)h > 0.2 && (double)s > 0.6 && (double)v < 0.25 && (double)v > 0.15) {
            return ChatColor.DARK_RED;
        }
        if (h > 833333.0f && h < 94.0f && (double)s > 0.6 && (double)v < 0.4 && (double)v > 0.15) {
            return ChatColor.DARK_PURPLE;
        }
        if ((double)h > 0.47222222 && (double)h < 0.541 && (double)s < 0.4 && (double)s > 0.2 && (double)v > 0.8) {
            return ChatColor.BLUE;
        }
        if ((double)h > 0.541 && (double)h < 0.64 && (double)s < 0.4 && (double)s > 0.2 && (double)v > 0.3) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)h > 0.47222222 && (double)h < 0.541 && (double)s < 0.4 && (double)s > 0.2 && (double)v < 0.5 && (double)v > 0.2) {
            return ChatColor.DARK_BLUE;
        }
        if ((double)h > 0.32 && (double)h < 0.501 && (double)s > 0.99 && (double)v < 0.12) {
            return ChatColor.GRAY;
        }
        if ((double)h > 0.85 && (double)s > 0.2 && (double)s < 0.41 && (double)v > 0.9) {
            return ChatColor.LIGHT_PURPLE;
        }
        if ((double)h > 0.763 && (double)s > 0.2 && (double)s < 0.41 && (double)v > 0.5) {
            return ChatColor.DARK_PURPLE;
        }
        if ((double)h > 0.125 && (double)h < 0.191666666 && (double)s > 0.25 && (double)s < 0.4 && (double)b.intValue() > 0.89) {
            return ChatColor.YELLOW;
        }
        if ((double)h > 0.125 && (double)h < 0.191666666 && (double)s > 0.25 && (double)s < 0.4 && (double)b.intValue() < 0.81 && (double)b.intValue() > 0.3) {
            return ChatColor.DARK_RED;
        }
        if ((double)h > 0.222222 && (double)h < 0.2777777777 && (double)s > 0.2 && (double)s > 0.4 && (double)b.intValue() > 0.85) {
            return ChatColor.GREEN;
        }
        if ((double)h > 0.222222 && (double)h < 0.2777777777 && (double)s > 0.2 && (double)s > 0.4 && (double)b.intValue() > 0.4 && (double)b.intValue() < 0.8) {
            return ChatColor.DARK_GREEN;
        }
        if ((double)s < 0.114 && (double)b.intValue() < 0.71 && (double)b.intValue() > 0.15) {
            return ChatColor.GRAY;
        }
        return ChatColor.WHITE;
    }

    public static enum ImgChar {
        BLOCK('\u2588'),
        DARK_SHADE('\u2593'),
        MEDIUM_SHADE('\u2592'),
        LIGHT_SHADE('\u2591');

        private char c;

        private ImgChar(char c) {
            this.c = c;
        }

        public char getChar() {
            return this.c;
        }
    }
}

