/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.playerblocktracker;

import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractListener;
import su.nightexpress.moneyhunters.playerblocktracker.PlayerBlockTracker;

public class TrackListener<P extends NexPlugin<P>>
extends AbstractListener<P> {
    private static final String META_TRACK_FALLING_BLOCK = "tracker_falling_block";

    public TrackListener(@NotNull P plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLoad(WorldLoadEvent event) {
        PlayerBlockTracker.initWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUnload(WorldUnloadEvent event) {
        PlayerBlockTracker.terminateWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLoad(ChunkLoadEvent event) {
        PlayerBlockTracker.initChunk(event.getChunk());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUnload(ChunkUnloadEvent event) {
        PlayerBlockTracker.terminateChunk(event.getChunk());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        PlayerBlockTracker.track(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExplode(BlockExplodeEvent event) {
        PlayerBlockTracker.unTrack(event.blockList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExplode(EntityExplodeEvent event) {
        PlayerBlockTracker.unTrack(event.blockList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBurn(BlockBurnEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFade(BlockFadeEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onForm(BlockFormEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlow(BlockFromToEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGrow(BlockGrowEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        PlayerBlockTracker.track(e.getBlocks().stream().map(BlockState::getBlock).toList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMultiPlace(BlockMultiPlaceEvent event) {
        PlayerBlockTracker.track(event.getReplacedBlockStates().stream().map(BlockState::getBlock).toList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        PlayerBlockTracker.shift(event.getDirection(), event.getBlocks());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        PlayerBlockTracker.shift(event.getDirection(), event.getBlocks());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpread(BlockSpreadEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityForm(EntityBlockFormEvent event) {
        PlayerBlockTracker.unTrack(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityFallingSpawn(EntitySpawnEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof FallingBlock)) {
            return;
        }
        Block block = entity.getLocation().getBlock();
        if (!PlayerBlockTracker.isTracked(block)) {
            return;
        }
        entity.setMetadata(META_TRACK_FALLING_BLOCK, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        PlayerBlockTracker.unTrack(block);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityFallingLand(EntityChangeBlockEvent e) {
        Entity entity = e.getEntity();
        if (!entity.hasMetadata(META_TRACK_FALLING_BLOCK)) {
            return;
        }
        PlayerBlockTracker.trackForce(e.getBlock());
    }
}

