/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.playerblocktracker;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nightexpress.moneyhunters.playerblocktracker.TrackListener;
import su.nightexpress.moneyhunters.playerblocktracker.TrackedWorld;

public final class PlayerBlockTracker {
    public static final Set<Predicate<Block>> BLOCK_FILTERS = new HashSet<Predicate<Block>>();
    public static final NamespacedKey TRACKED_DATA_KEY = NamespacedKey.minecraft((String)"tracked_chunk_data");
    private static final Map<UUID, TrackedWorld> TRACKED_WORLD_MAP = new Object2ObjectOpenHashMap();
    private static TrackListener<?> listener;

    public static <P extends NexPlugin<P>> void initialize(@NotNull P plugin) {
        if (listener == null) {
            PlayerBlockTracker.initCurrentlyLoadedWorlds();
            listener = new TrackListener<P>(plugin);
            listener.registerListeners();
        }
    }

    public static void shutdown() {
        if (listener != null) {
            PlayerBlockTracker.terminateCurrentlyLoadedWorlds();
            listener.unregisterListeners();
            BLOCK_FILTERS.clear();
        }
    }

    public static void initWorld(@NotNull World world) {
        TrackedWorld trackedWorld = new TrackedWorld();
        for (Chunk loadedChunk : world.getLoadedChunks()) {
            trackedWorld.initChunk(loadedChunk);
        }
        TRACKED_WORLD_MAP.put(world.getUID(), trackedWorld);
    }

    public static void terminateWorld(@NotNull World world) {
        TrackedWorld trackedWorld = TRACKED_WORLD_MAP.remove(world.getUID());
        if (trackedWorld == null) {
            return;
        }
        for (Chunk loadedChunk : world.getLoadedChunks()) {
            trackedWorld.terminateChunk(loadedChunk);
        }
    }

    public static void initChunk(@NotNull Chunk chunk) {
        TrackedWorld trackedWorld = PlayerBlockTracker.getTrackedWorldOf(chunk);
        if (trackedWorld == null) {
            return;
        }
        trackedWorld.initChunk(chunk);
    }

    public static void terminateChunk(@NotNull Chunk chunk) {
        TrackedWorld trackedWorld = PlayerBlockTracker.getTrackedWorldOf(chunk);
        if (trackedWorld == null) {
            return;
        }
        trackedWorld.terminateChunk(chunk);
    }

    public static void initCurrentlyLoadedWorlds() {
        Bukkit.getWorlds().forEach(PlayerBlockTracker::initWorld);
    }

    public static void terminateCurrentlyLoadedWorlds() {
        Bukkit.getWorlds().forEach(PlayerBlockTracker::terminateWorld);
    }

    public static boolean isTracked(@NotNull Block block) {
        TrackedWorld trackedWorld = PlayerBlockTracker.getTrackedWorldOf(block);
        if (trackedWorld == null) {
            return false;
        }
        return trackedWorld.isTracked(block);
    }

    public static void track(@NotNull Block block) {
        if (BLOCK_FILTERS.stream().noneMatch(filter -> filter.test(block))) {
            return;
        }
        PlayerBlockTracker.trackForce(block);
    }

    public static void trackForce(@NotNull Block block) {
        TrackedWorld trackedWorld = PlayerBlockTracker.getTrackedWorldOf(block);
        if (trackedWorld == null) {
            return;
        }
        trackedWorld.add(block);
    }

    public static void unTrack(@NotNull Block block) {
        TrackedWorld trackedWorld = PlayerBlockTracker.getTrackedWorldOf(block);
        if (trackedWorld == null) {
            return;
        }
        trackedWorld.remove(block);
    }

    public static void track(@NotNull Collection<Block> trackedBlocks) {
        trackedBlocks.forEach(PlayerBlockTracker::trackForce);
    }

    public static void unTrack(@NotNull Collection<Block> trackedBlocks) {
        trackedBlocks.forEach(PlayerBlockTracker::unTrack);
    }

    public static void shift(@NotNull BlockFace direction, @NotNull List<Block> blocks) {
        PlayerBlockTracker.unTrack(blocks);
        PlayerBlockTracker.track(blocks.stream().map(block -> block.getRelative(direction)).toList());
    }

    public static void move(@NotNull Block from, @NotNull Block to) {
        PlayerBlockTracker.unTrack(from);
        PlayerBlockTracker.track(to);
    }

    @Nullable
    private static TrackedWorld getTrackedWorldOf(@NotNull Block block) {
        return TRACKED_WORLD_MAP.get(block.getWorld().getUID());
    }

    @Nullable
    private static TrackedWorld getTrackedWorldOf(@NotNull Chunk chunk) {
        return TRACKED_WORLD_MAP.get(chunk.getWorld().getUID());
    }
}

