/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.money.task;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.task.AbstractTask;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.currency.ICurrency;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.manager.money.MoneyManager;

public class MoneyMergeTask
extends AbstractTask<MoneyHunters> {
    private static final Set<Item> MERGE = new HashSet<Item>();

    public MoneyMergeTask(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, 2, false);
    }

    public void stop() {
        super.stop();
        MERGE.clear();
    }

    public static void addItem(@NotNull Item item) {
        MERGE.add(item);
    }

    public void action() {
        MERGE.removeIf(item -> !item.isValid() || item.isDead());
        MERGE.stream().filter(Entity::isOnGround).forEach(item -> {
            if (!item.isValid() || item.isDead()) {
                return;
            }
            ItemStack stackSrc = item.getItemStack();
            ICurrency currencySrc = MoneyManager.getMoneyCurrency(stackSrc);
            if (currencySrc == null) {
                item.remove();
                return;
            }
            String ownerSrc = MoneyManager.getMoneyOwner(stackSrc);
            IJob<?> jobSrc = MoneyManager.getMoneyJob(stackSrc);
            IMoneyObjective objectiveSrc = MoneyManager.getMoneyObjective(stackSrc);
            double moneySrc = MoneyManager.getMoneyAmount(stackSrc);
            for (Entity near : item.getNearbyEntities(5.0, 1.0, 5.0)) {
                ICurrency currencyNear;
                IMoneyObjective objectiveNear;
                IJob<?> jobNear;
                String ownerNear;
                Item nearItem;
                ItemStack stackNear;
                Entity nearItem$temp = near;
                if (!(nearItem$temp instanceof Item) || !MoneyManager.isMoneyItem(stackNear = (nearItem = (Item)nearItem$temp).getItemStack()) || (ownerNear = MoneyManager.getMoneyOwner(stackNear)) != null && !ownerNear.equalsIgnoreCase(ownerSrc) || (jobNear = MoneyManager.getMoneyJob(stackNear)) != jobSrc || objectiveSrc != (objectiveNear = MoneyManager.getMoneyObjective(stackNear)) || (currencyNear = MoneyManager.getMoneyCurrency(stackNear)) != currencySrc) continue;
                moneySrc += MoneyManager.getMoneyAmount(stackNear);
                near.remove();
            }
            Player player = ownerSrc != null ? ((MoneyHunters)this.plugin).getServer().getPlayer(ownerSrc) : null;
            ItemStack money = currencySrc.createMoney(moneySrc, player, jobSrc, objectiveSrc);
            item.setCustomName(ItemUtil.getItemName((ItemStack)money));
            item.setItemStack(money);
        });
    }
}

