/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.money;

import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.manager.IListener;
import su.nexmedia.engine.hooks.Hooks;
import su.nexmedia.engine.utils.MessageUtil;
import su.nexmedia.engine.utils.PDCUtil;
import su.nightexpress.ama.arena.ArenaPlayer;
import su.nightexpress.moneyhunters.basic.Keys;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.MoneyHuntersAPI;
import su.nightexpress.moneyhunters.basic.api.currency.ICurrency;
import su.nightexpress.moneyhunters.basic.api.event.PlayerMoneyGainEvent;
import su.nightexpress.moneyhunters.basic.api.event.PlayerMoneyLoseEvent;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.manager.money.listener.MoneyListenerGeneric;
import su.nightexpress.moneyhunters.basic.manager.money.listener.MoneyListenerGlitch;
import su.nightexpress.moneyhunters.basic.manager.money.task.InventoryCheckTask;
import su.nightexpress.moneyhunters.basic.manager.money.task.MoneyMergeTask;

public class MoneyManager
extends AbstractManager<MoneyHunters> {
    private InventoryCheckTask inventoryCheckTask;
    private MoneyMergeTask moneyMergeTask;

    public MoneyManager(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin);
    }

    public void onLoad() {
        this.addListener((IListener)new MoneyListenerGeneric(this));
        this.addListener((IListener)new MoneyListenerGlitch((MoneyHunters)this.plugin));
        this.inventoryCheckTask = new InventoryCheckTask(this);
        this.inventoryCheckTask.start();
        if (Config.MONEY_MERGING_ENABLED) {
            this.moneyMergeTask = new MoneyMergeTask((MoneyHunters)this.plugin);
            this.moneyMergeTask.start();
        }
    }

    public void onShutdown() {
        if (this.inventoryCheckTask != null) {
            this.inventoryCheckTask.stop();
            this.inventoryCheckTask = null;
        }
        if (this.moneyMergeTask != null) {
            this.moneyMergeTask.stop();
            this.moneyMergeTask = null;
        }
    }

    public static boolean isMoneyAvailable(@NotNull Player player) {
        if (Hooks.isCitizensNPC((Entity)player)) {
            return false;
        }
        if (Config.GEN_DISABLED_WORLDS.contains(player.getWorld().getName())) {
            return false;
        }
        if (Config.GEN_GLITCH_IGNORE_GAME_MODES.contains(player.getGameMode().name())) {
            return false;
        }
        if (Config.isDisabledRegion(player)) {
            return false;
        }
        return !Config.GEN_HOOKS_DISABLED_ON_MOB_ARENA || !ArenaPlayer.isPlaying((Player)player);
    }

    public static boolean isMoneyItem(@NotNull ItemStack item) {
        return PDCUtil.getDoubleData((ItemStack)item, (NamespacedKey)Keys.MONEY_AMOUNT) != 0.0;
    }

    public static boolean isMoneyOwner(@NotNull ItemStack item, @NotNull Player player) {
        String owner = MoneyManager.getMoneyOwner(item);
        return owner == null || player.getName().equalsIgnoreCase(owner);
    }

    @Nullable
    public static String getMoneyOwner(@NotNull ItemStack item) {
        return PDCUtil.getStringData((ItemStack)item, (NamespacedKey)Keys.MONEY_OWNER);
    }

    @Nullable
    public static IJob<?> getMoneyJob(@NotNull ItemStack item) {
        String jobId = PDCUtil.getStringData((ItemStack)item, (NamespacedKey)Keys.MONEY_JOB);
        return jobId == null ? null : MoneyHuntersAPI.getJobById(jobId);
    }

    @Nullable
    public static IMoneyObjective getMoneyObjective(@NotNull ItemStack item) {
        String type = PDCUtil.getStringData((ItemStack)item, (NamespacedKey)Keys.MONEY_OBJECTIVE);
        if (type == null) {
            return null;
        }
        IJob<?> job = MoneyManager.getMoneyJob(item);
        return job == null ? null : job.getObjective(type);
    }

    @Nullable
    public static ICurrency getMoneyCurrency(@NotNull ItemStack item) {
        String currencyId = PDCUtil.getStringData((ItemStack)item, (NamespacedKey)Keys.MONEY_CURRENCY);
        return currencyId == null ? null : MoneyHuntersAPI.getCurrency(currencyId);
    }

    public static double getMoneyAmount(@NotNull ItemStack item) {
        return PDCUtil.getDoubleData((ItemStack)item, (NamespacedKey)Keys.MONEY_AMOUNT);
    }

    public static void devastateEntity(@NotNull Entity entity) {
        PDCUtil.setData((PersistentDataHolder)entity, (NamespacedKey)Keys.MONEY_NO_DROP, (Object)true);
    }

    public static boolean isDevastated(@NotNull Entity entity) {
        return PDCUtil.getBooleanData((PersistentDataHolder)entity, (NamespacedKey)Keys.MONEY_NO_DROP);
    }

    public boolean pickupMoney(@NotNull Player player, @NotNull ItemStack item) {
        ICurrency currency = MoneyManager.getMoneyCurrency(item);
        if (currency == null) {
            return false;
        }
        double money = MoneyManager.getMoneyAmount(item);
        boolean isLose = money < 0.0;
        IJob<?> job = MoneyManager.getMoneyJob(item);
        IMoneyObjective objective = MoneyManager.getMoneyObjective(item);
        if (isLose) {
            return this.loseMoney(player, currency, money, job, objective);
        }
        return this.gainMoney(player, currency, money, job, objective);
    }

    public boolean loseMoney(@NotNull Player player, @NotNull ICurrency currency, double money) {
        return this.loseMoney(player, currency, money, null, null);
    }

    public boolean loseMoney(@NotNull Player player, @NotNull ICurrency currency, double money, @Nullable IJob<?> job, @Nullable IMoneyObjective objective) {
        PlayerMoneyLoseEvent event = new PlayerMoneyLoseEvent(player, money, job, objective);
        ((MoneyHunters)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        money = event.getAmount();
        currency.take(player, money);
        ((MoneyHunters)this.plugin).getMessage(Lang.MONEY_LOST).replace("%money%", (Object)currency.format(money)).replace("%balance%", (Object)currency.format(currency.getBalance(player))).send((CommandSender)player);
        if (job != null && objective != null) {
            ((MoneyHunters)this.plugin).getJobManager().countObjective(player, -money, job, objective, ObjectiveLimitType.MONEY);
        }
        return true;
    }

    public boolean gainMoney(@NotNull Player player, @NotNull ICurrency currency, double money) {
        return this.gainMoney(player, currency, money, null, null);
    }

    public boolean gainMoney(@NotNull Player player, @NotNull ICurrency currency, double money, @Nullable IJob<?> job, @Nullable IMoneyObjective objective) {
        PlayerMoneyGainEvent event = new PlayerMoneyGainEvent(player, money, job, objective);
        ((MoneyHunters)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        money = event.getAmount();
        currency.give(player, money);
        Sound sound = currency.getPickupEffectSound();
        if (sound != null) {
            MessageUtil.sound((Player)player, (Sound)sound);
        }
        ((MoneyHunters)this.plugin).getMessage(Lang.MONEY_PICKUP).replace("%money%", (Object)currency.format(money)).replace("%balance%", (Object)currency.format(currency.getBalance(player))).send((CommandSender)player);
        if (job != null && objective != null) {
            ((MoneyHunters)this.plugin).getJobManager().countObjective(player, money, job, objective, ObjectiveLimitType.MONEY);
        }
        return true;
    }
}

