/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.job;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.manager.ICleanable;
import su.nexmedia.engine.api.manager.IListener;
import su.nexmedia.engine.utils.FileUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.MoneyHuntersAPI;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobState;
import su.nightexpress.moneyhunters.basic.api.job.JobType;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;
import su.nightexpress.moneyhunters.basic.data.object.UserObjectiveLimit;
import su.nightexpress.moneyhunters.basic.manager.job.JobFactory;
import su.nightexpress.moneyhunters.basic.manager.job.listener.JobListenerGeneric;
import su.nightexpress.moneyhunters.basic.manager.job.listener.JobListenerMythic;
import su.nightexpress.moneyhunters.playerblocktracker.PlayerBlockTracker;

public class JobManager
extends AbstractManager<MoneyHunters> {
    private JobFactory jobFactory;
    private Map<String, IJob<?>> jobs;
    private Predicate<Block> jobBlockTracker;
    public static final String DIR_JOBS = "/jobs/";

    public JobManager(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin);
    }

    public void onLoad() {
        ((MoneyHunters)this.plugin).getConfigManager().extractResources(DIR_JOBS);
        this.jobs = new HashMap();
        this.jobFactory = new JobFactory((MoneyHunters)this.plugin);
        this.jobFactory.setup();
        FileUtil.getFolders((String)(((MoneyHunters)this.plugin).getDataFolder() + DIR_JOBS)).forEach(this::loadJob);
        ((MoneyHunters)this.plugin).info("Jobs Loaded: " + this.jobs.size());
        this.addListener((IListener)new JobListenerGeneric(this));
        if (this.getJobs().stream().anyMatch(job -> job.getType() == JobType.KILL_MYTHIC)) {
            this.addListener((IListener)new JobListenerMythic(this));
        }
        this.jobBlockTracker = block -> {
            IJob<?> job = this.getJobByType(JobType.BLOCK_BREAK, block.getType().name());
            return job != null;
        };
        PlayerBlockTracker.BLOCK_FILTERS.add(this.jobBlockTracker);
    }

    public void onShutdown() {
        PlayerBlockTracker.BLOCK_FILTERS.remove(this.jobBlockTracker);
        if (this.jobFactory != null) {
            this.jobFactory.shutdown();
            this.jobFactory = null;
        }
        if (this.jobs != null) {
            this.jobs.values().forEach(ICleanable::clear);
            this.jobs.clear();
            this.jobs = null;
        }
    }

    public void loadJob(@NotNull File jobDir) {
        JYML cfg = JYML.loadOrExtract((NexPlugin)this.plugin, (String)(DIR_JOBS + jobDir.getName() + "/" + jobDir.getName() + ".yml"));
        cfg.addMissing("Enabled", (Object)true);
        cfg.saveChanges();
        if (!cfg.getBoolean("Enabled")) {
            return;
        }
        JobType jobType = (JobType)cfg.getEnum("Type", JobType.class);
        if (jobType == null) {
            ((MoneyHunters)this.plugin).error("Invalid job type for '" + cfg.getFile().getName() + "' job!");
            return;
        }
        try {
            IJob<?> job = this.getJobFactory().createJob(cfg, jobType);
            this.jobs.put(job.getId(), job);
        }
        catch (Exception ex) {
            ((MoneyHunters)this.plugin).error("Could not load job '" + cfg.getFile().getName() + "': " + ex.getMessage());
        }
    }

    @NotNull
    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    @Nullable
    public IJob<?> getJobByType(@NotNull JobType type, @NotNull String src) {
        return this.getJobs().stream().filter(job -> job.getType() == type && job.hasObjective(src)).findFirst().orElse(null);
    }

    @Nullable
    public IJob<?> getJobById(@NotNull String id) {
        return this.jobs.get(id.toLowerCase());
    }

    @NotNull
    public Collection<IJob<?>> getJobs() {
        return this.jobs.values();
    }

    @NotNull
    public Collection<IJob<?>> getJobs(@NotNull Player player) {
        return this.getJobs().stream().filter(job -> job.hasPermission(player)).toList();
    }

    @NotNull
    public List<String> getJobIds() {
        return new ArrayList<String>(this.jobs.keySet());
    }

    @NotNull
    public List<String> getJobIds(@NotNull Player player) {
        return this.getJobs(player).stream().map(IJob::getId).toList();
    }

    public static int getJobsAmountMax(@NotNull Player player, @NotNull JobState state) {
        return -1;
    }

    public static int getJobsAmount(@NotNull Player player, @NotNull JobState state) {
        MoneyUser user = MoneyHuntersAPI.getPlayerData(player);
        return user.getJobsAmount(state);
    }

    public void countObjective(@NotNull Player player, double amount, @NotNull IJob<?> job, @NotNull IMoneyObjective objective, @NotNull ObjectiveLimitType limitType) {
        if (job.hasObjectiveLimitBypass(player, limitType)) {
            return;
        }
        MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(player);
        UserJobData jobData = user.getJobData(job);
        boolean isLose = amount < 0.0;
        UserObjectiveLimit limit = jobData.getObjectiveLimit(objective.getType());
        limit.setCount(limitType, limit.getCount(limitType) + amount);
        if (jobData.isObjectWasted(objective, limitType) && !limit.isNotified(limitType)) {
            ((MoneyHunters)this.plugin).getMessage(Lang.JOB_OBJECTIVES_LIMITS_NOTIFY).replace(jobData.replacePlaceholders()).replace(objective.replacePlaceholders(job.getCurrency(), jobData.getJobLevel())).replace("%limit_type%", (Object)((MoneyHunters)this.plugin).getLangManager().getEnum((Enum)limitType)).send((CommandSender)player);
            limit.setNotified(limitType, true);
        }
    }
}

