/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.job;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.hooks.Hooks;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobType;
import su.nightexpress.moneyhunters.basic.manager.job.object.JobBlockBreak;
import su.nightexpress.moneyhunters.basic.manager.job.object.JobEntityKill;
import su.nightexpress.moneyhunters.basic.manager.job.object.JobFishing;
import su.nightexpress.moneyhunters.basic.manager.job.object.JobMythicKill;

public class JobFactory
extends AbstractManager<MoneyHunters> {
    private Set<JobBlockBreak> jobsBlockBreak;
    private Set<JobFishing> jobsFishing;
    private Set<JobEntityKill> jobsEntityKill;
    private Set<JobMythicKill> jobsMythicKill;

    public JobFactory(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin);
    }

    protected void onLoad() {
        this.jobsBlockBreak = new HashSet<JobBlockBreak>();
        this.jobsFishing = new HashSet<JobFishing>();
        this.jobsEntityKill = new HashSet<JobEntityKill>();
        this.jobsMythicKill = new HashSet<JobMythicKill>();
    }

    protected void onShutdown() {
        this.jobsBlockBreak.clear();
        this.jobsFishing.clear();
        this.jobsEntityKill.clear();
        this.jobsMythicKill.clear();
    }

    @NotNull
    public IJob<?> createJob(@NotNull JYML cfg, @NotNull JobType jobType) {
        return switch (jobType) {
            case JobType.FISHING -> {
                JobFishing job = new JobFishing((MoneyHunters)this.plugin, cfg);
                this.getJobsFishing().add(job);
                yield job;
            }
            case JobType.BLOCK_BREAK -> {
                JobBlockBreak job = new JobBlockBreak((MoneyHunters)this.plugin, cfg);
                this.getJobsBlockBreak().add(job);
                yield job;
            }
            case JobType.KILL_ENTITY -> {
                JobEntityKill job = new JobEntityKill((MoneyHunters)this.plugin, cfg);
                this.getJobsEntityKill().add(job);
                yield job;
            }
            case JobType.KILL_MYTHIC -> {
                if (!Hooks.hasPlugin((String)"MythicMobs")) {
                    throw new IllegalStateException("No dependency installed: MythicMobs");
                }
                JobMythicKill job = new JobMythicKill((MoneyHunters)this.plugin, cfg);
                this.getJobsMythicKill().add(job);
                yield job;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @NotNull
    public Set<JobBlockBreak> getJobsBlockBreak() {
        return this.jobsBlockBreak;
    }

    @NotNull
    public Set<JobFishing> getJobsFishing() {
        return this.jobsFishing;
    }

    @NotNull
    public Set<JobEntityKill> getJobsEntityKill() {
        return this.jobsEntityKill;
    }

    @NotNull
    public Set<JobMythicKill> getJobsMythicKill() {
        return this.jobsMythicKill;
    }
}

