/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.booster.object;

import java.time.LocalDateTime;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.TimeUtil;
import su.nightexpress.moneyhunters.basic.api.booster.AbstractBooster;
import su.nightexpress.moneyhunters.basic.api.booster.BoosterType;

public class PersonalBooster
extends AbstractBooster {
    private final long timeEnd;

    public PersonalBooster(@NotNull String id, @NotNull Set<String> jobs, double moneyModifier, double expModifier, int duration) {
        this(id, jobs, moneyModifier, expModifier, TimeUtil.toEpochMillis((LocalDateTime)LocalDateTime.now().plusMinutes(duration)));
    }

    public PersonalBooster(@NotNull String id, @NotNull Set<String> jobs, double moneyModifier, double expModifier, long timeEnd) {
        super(id, jobs, moneyModifier, expModifier);
        this.timeEnd = timeEnd;
    }

    @Override
    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> (String)super.replacePlaceholders().apply(str.replace("%booster_time_left%", TimeUtil.formatTimeLeft((long)this.getTimeEnd())));
    }

    @Override
    @NotNull
    public BoosterType getType() {
        return BoosterType.PERSONAL;
    }

    public long getTimeEnd() {
        return this.timeEnd;
    }

    @Override
    public boolean isExpired() {
        return LocalDateTime.now().isAfter(TimeUtil.getLocalDateTimeOf((long)this.getTimeEnd()));
    }

    @Override
    public boolean isAwaiting() {
        return false;
    }
}

