/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.manager.booster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.manager.IListener;
import su.nexmedia.engine.utils.MessageUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.manager.booster.listener.BoosterListenerGeneric;
import su.nightexpress.moneyhunters.basic.manager.booster.task.BoosterTask;

public class BoosterManager
extends AbstractManager<MoneyHunters> {
    private Set<IBooster> boostersAuto;
    private Set<IBooster> boostersGlobal;
    private BoosterTask boosterTask;

    public BoosterManager(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin);
    }

    protected void onLoad() {
        this.boostersAuto = new HashSet<IBooster>();
        this.boostersGlobal = new HashSet<IBooster>();
        this.boosterTask = new BoosterTask((MoneyHunters)this.plugin);
        this.boosterTask.start();
        this.addListener((IListener)new BoosterListenerGeneric((MoneyHunters)this.plugin));
    }

    protected void onShutdown() {
        if (this.boosterTask != null) {
            this.boosterTask.stop();
            this.boosterTask = null;
        }
        this.boostersGlobal.clear();
        this.boostersAuto.clear();
    }

    public static double getBoosterMoney(@NotNull Collection<IBooster> boosters) {
        return (boosters.stream().mapToDouble(IBooster::getMoneyPercent).sum() + 100.0) / 100.0;
    }

    public static double getBoosterExp(@NotNull Collection<IBooster> boosters) {
        return (boosters.stream().mapToDouble(IBooster::getExpPercent).sum() + 100.0) / 100.0;
    }

    public static double getBoosterMoneyPercent(@NotNull Collection<IBooster> boosters) {
        return boosters.stream().mapToDouble(IBooster::getMoneyPercent).sum();
    }

    public static double getBoosterExpPercent(@NotNull Collection<IBooster> boosters) {
        return boosters.stream().mapToDouble(IBooster::getExpPercent).sum();
    }

    @NotNull
    public Collection<IBooster> getBoostersAuto() {
        return this.boostersAuto;
    }

    @NotNull
    public Collection<IBooster> getBoostersAuto(@NotNull IJob<?> job) {
        return this.getBoostersAuto().stream().filter(booster -> booster.isApplicable(job)).toList();
    }

    @NotNull
    public Set<IBooster> getBoostersGlobal() {
        return this.boostersGlobal;
    }

    @NotNull
    public Collection<IBooster> getBoostersGlobal(@NotNull IJob<?> job) {
        return this.getBoostersGlobal().stream().filter(booster -> booster.isApplicable(job)).toList();
    }

    public void updateBoosters() {
        this.getBoostersGlobal().removeIf(IBooster::isExpired);
        this.getBoostersAuto().removeIf(IBooster::isExpired);
        this.getBoostersAuto().addAll(Config.getBoosters().stream().filter(IBooster::isActive).toList());
        for (Player player : ((MoneyHunters)this.plugin).getServer().getOnlinePlayers()) {
            if (!((MoneyHunters)this.plugin).getUserManager().isUserLoaded(player)) continue;
            MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(player);
            user.updateBoosters();
        }
    }

    public void notifyBooster() {
        this.notifyBooster(((MoneyHunters)this.plugin).getServer().getOnlinePlayers().toArray(new Player[0]));
    }

    public void notifyBooster(Player ... players) {
        ArrayList<IBooster> boosters = new ArrayList<IBooster>();
        boosters.addAll(this.getBoostersAuto());
        boosters.addAll(this.getBoostersGlobal());
        if (boosters.isEmpty()) {
            return;
        }
        List message = ((MoneyHunters)this.plugin).getMessage(Lang.BOOSTER_GLOBAL_NOTIFY).asList();
        for (Player player : players) {
            for (String line : message) {
                if (line.contains("%booster_")) {
                    boosters.forEach(booster -> MessageUtil.sendWithJSON((CommandSender)player, (String)((String)booster.replacePlaceholders().apply(line))));
                    continue;
                }
                MessageUtil.sendWithJSON((CommandSender)player, (String)line);
            }
        }
    }
}

