/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Set;
import su.nightexpress.moneyhunters.basic.manager.booster.object.PersonalBooster;

public class PersonalBoosterSerializer
implements JsonSerializer<PersonalBooster>,
JsonDeserializer<PersonalBooster> {
    public PersonalBooster deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = element.getAsJsonObject();
        if (object.get("id") == null) {
            return null;
        }
        String id = object.get("id").getAsString();
        Set jobs = (Set)context.deserialize(object.get("jobs"), new TypeToken<Set<String>>(){}.getType());
        double moneyModifier = object.get("moneyModifier").getAsDouble();
        double expModifier = object.get("expModifier").getAsDouble();
        long timeEnd = object.get("timeEnd").getAsLong();
        return new PersonalBooster(id, (Set<String>)jobs, moneyModifier, expModifier, timeEnd);
    }

    public JsonElement serialize(PersonalBooster booster, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("id", booster.getId());
        object.add("jobs", context.serialize(booster.getJobs(), new TypeToken<Set<String>>(){}.getType()));
        object.addProperty("moneyModifier", (Number)booster.getMoneyModifier());
        object.addProperty("expModifier", (Number)booster.getExpModifier());
        object.addProperty("timeEnd", (Number)booster.getTimeEnd());
        return object;
    }
}

