/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nightexpress.moneyhunters.basic.MoneyHuntersAPI;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobState;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;
import su.nightexpress.moneyhunters.basic.data.object.UserObjectiveLimit;

public class JobDataSerializer
implements JsonDeserializer<UserJobData>,
JsonSerializer<UserJobData> {
    public UserJobData deserialize(JsonElement json, Type type, JsonDeserializationContext contex) throws JsonParseException {
        IJob<?> job;
        JobState jobState;
        int jobExp;
        int jobLevel;
        String jobId;
        JsonObject object = json.getAsJsonObject();
        if (object.get("id") != null) {
            jobId = object.get("id").getAsString();
            jobLevel = object.get("lvl").getAsInt();
            jobExp = object.get("exp").getAsInt();
        } else {
            jobId = object.get("jobId").getAsString();
            jobLevel = object.get("jobLevel").getAsInt();
            jobExp = object.get("jobExp").getAsInt();
        }
        if (object.get("jobState") != null) {
            jobState = (JobState)CollectionsUtil.getEnum((String)object.get("jobState").getAsString(), JobState.class);
            if (jobState == null) {
                jobState = JobState.PRIMARY;
            }
        } else {
            jobState = JobState.PRIMARY;
        }
        if ((job = MoneyHuntersAPI.getJobById(jobId)) == null) {
            return null;
        }
        JsonElement limitsObj = object.get("dailyLimits");
        if (limitsObj == null) {
            limitsObj = object.get("objectCount");
        }
        Map limits = limitsObj != null ? (Map)contex.deserialize(limitsObj, new TypeToken<Map<String, UserObjectiveLimit>>(){}.getType()) : new HashMap();
        return new UserJobData(job, jobState, jobLevel, jobExp, limits);
    }

    public JsonElement serialize(UserJobData src, Type type, JsonSerializationContext contex) {
        JsonObject object = new JsonObject();
        object.addProperty("jobId", src.getJob().getId());
        object.addProperty("jobState", src.getState().name());
        object.addProperty("jobLevel", (Number)src.getJobLevel());
        object.addProperty("jobExp", (Number)src.getJobExp());
        object.add("perkLevels", contex.serialize(src.getPerkLevels()));
        object.add("dailyLimits", contex.serialize(src.getDailyLimits()));
        return object;
    }
}

