/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.data.object;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.NumberUtil;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobState;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserObjectiveLimit;

public class UserJobData {
    private final transient IJob<?> job;
    private transient double moneyModifier;
    private JobState state;
    private int jobLevel;
    private int jobExp;
    private int jobExpMax;
    private final Map<String, Integer> perkLevels;
    private final Map<String, UserObjectiveLimit> dailyLimits;

    public UserJobData(@NotNull IJob<?> job) {
        this(job, job.getStateDefault(), job.getLevelStart(), 0, new HashMap<String, UserObjectiveLimit>());
    }

    public UserJobData(@NotNull IJob<?> job, @NotNull JobState state, int jobLevel, int jobExp, @NotNull Map<String, UserObjectiveLimit> dailyLimits) {
        this.job = job;
        this.setState(state);
        this.dailyLimits = dailyLimits;
        this.perkLevels = new HashMap<String, Integer>();
        if (Config.LEVELING_ENABLED) {
            this.jobLevel = jobLevel;
            this.jobExp = jobExp;
            this.update();
        } else {
            this.jobLevel = 1;
            this.jobExp = 0;
            this.jobExpMax = 0;
            this.moneyModifier = 1.0;
        }
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders(@NotNull MoneyUser user) {
        Collection<IBooster> boosters = user.getBoosters(this.getJob());
        double boostExp = boosters.stream().mapToDouble(IBooster::getExpPercent).sum();
        double boostMoney = boosters.stream().mapToDouble(IBooster::getMoneyPercent).sum();
        return str -> (String)this.replacePlaceholders().apply(str.replace("%job_booster_exp%", NumberUtil.format((double)boostExp)).replace("%job_booster_money%", NumberUtil.format((double)boostMoney)));
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        IJob<?> job = this.getJob();
        return str -> (String)job.replacePlaceholders().apply(str.replace("%job_state%", job.plugin().getLangManager().getEnum((Enum)this.getState())).replace("%job_exp%", NumberUtil.format((double)this.getJobExp())).replace("%job_exp_max%", NumberUtil.format((double)this.getJobExpMax())).replace("%job_level%", NumberUtil.format((double)this.getJobLevel())).replace("%job_level_max%", NumberUtil.format((double)this.getJobLevelMax())).replace("%job_money_modifier%", NumberUtil.format((double)this.getMoneyModifier())));
    }

    public void reset() {
        IJob<?> job = this.getJob();
        this.setJobLevel(job.getLevelStart());
        this.setJobExp(0);
        this.setState(job.getStateDefault());
        this.getPerkLevels().clear();
        this.update();
    }

    public void update() {
        if (!Config.LEVELING_ENABLED) {
            return;
        }
        this.jobExpMax = this.job.getExpForLevel(this.getJobLevel());
        this.moneyModifier = this.job.getMoneyMultiplier(this.getState(), this.getJobLevel());
        if (this.getJobExp() >= this.getJobExpMax() && this.getJobLevel() < this.getJobLevelMax()) {
            this.upLevel(this.getJobExp() - this.getJobExpMax());
        }
    }

    @NotNull
    public IJob<?> getJob() {
        return this.job;
    }

    @NotNull
    public JobState getState() {
        return this.state;
    }

    public void setState(@NotNull JobState state) {
        this.state = state;
    }

    public int getJobLevel() {
        return this.jobLevel;
    }

    public void setJobLevel(int jobLevel) {
        this.jobLevel = Math.max(1, Math.min(jobLevel, this.getJobLevelMax()));
    }

    public int getJobLevelMax() {
        return this.getJob().getLevelMax(this.getState());
    }

    public int getJobExp() {
        return this.jobExp;
    }

    public void setJobExp(int jobExp) {
        this.jobExp = jobExp;
    }

    public int getJobExpMax() {
        return this.jobExpMax;
    }

    public void setJobExpMax(int jobExpMax) {
        this.jobExpMax = jobExpMax;
    }

    public final int getJobExpToUp() {
        return this.getJobExpMax() - this.getJobExp();
    }

    public final int getJobExpToDown() {
        return -(this.getJobExp() + this.getJobExpMax());
    }

    public double getMoneyModifier() {
        return this.moneyModifier;
    }

    @NotNull
    public Map<String, Integer> getPerkLevels() {
        return this.perkLevels;
    }

    public int getPerkLevel(@NotNull String id) {
        return this.perkLevels.getOrDefault(id.toLowerCase(), 0);
    }

    public void setPerkLevel(@NotNull String id, int level) {
        this.perkLevels.put(id.toLowerCase(), level);
    }

    @NotNull
    public Map<String, UserObjectiveLimit> getDailyLimits() {
        return this.dailyLimits;
    }

    @NotNull
    public UserObjectiveLimit getObjectiveLimit(@NotNull String objectId) {
        return this.dailyLimits.computeIfAbsent(objectId.toLowerCase(), counter -> new UserObjectiveLimit());
    }

    public boolean isObjectWasted(@NotNull IMoneyObjective objective, @NotNull ObjectiveLimitType type) {
        UserObjectiveLimit limit = this.getObjectiveLimit(objective.getType());
        limit.validateTime();
        return objective.isDailyLimited(type, this.getJobLevel()) && objective.getDailyLimit(type, this.getJobLevel()) <= limit.getCount(type);
    }

    public void takeExp(int expAdd) {
        this.addExp(-expAdd);
    }

    public void addExp(int expAdd) {
        int expHas = this.getJobExp();
        int expMax = this.getJobExpMax();
        int expToDown = this.getJobExpToDown();
        if (expAdd <= expToDown) {
            if (this.getJobLevel() == this.getJob().getLevelStart()) {
                this.setJobExp(-expMax);
            } else {
                int expLeft = Math.abs(expAdd) - Math.abs(expToDown);
                this.downLevel(expLeft);
            }
            return;
        }
        if (expHas + expAdd < expMax) {
            this.setJobExp(expHas + expAdd);
        } else if (this.getJobLevel() >= this.getJobLevelMax()) {
            this.setJobExp(this.getJobExpMax());
        } else {
            this.upLevel(expHas + expAdd - expMax);
        }
    }

    public void upLevel(int expLeft) {
        ++this.jobLevel;
        this.moneyModifier = this.job.getMoneyMultiplier(this.state, this.jobLevel);
        int expReq = this.getJob().getExpForLevel(this.getJobLevel());
        if (expReq <= 0) {
            expReq = this.getJob().getLevelExpStart();
        }
        this.jobExp = expLeft;
        this.jobExpMax = expReq;
        if (expLeft >= expReq) {
            if (this.getJobLevel() >= this.getJobLevelMax()) {
                this.addExp(1);
            } else {
                this.upLevel(expLeft - expReq);
            }
        }
    }

    public void downLevel(int expLeft) {
        if (this.getJobLevel() == this.getJob().getLevelStart()) {
            return;
        }
        int expMax = this.getJob().getExpForLevel(this.getJobLevel() - 1);
        if (expMax <= 0) {
            expMax = this.getJob().getLevelExpStart();
        }
        this.jobExp = -Math.abs(expLeft);
        this.jobExpMax = expMax;
        --this.jobLevel;
        this.moneyModifier = this.job.getMoneyMultiplier(this.state, this.jobLevel);
        int expDown = -this.getJobExpMax();
        if (this.getJobExp() <= expDown) {
            if (this.getJobLevel() == this.getJob().getLevelStart()) {
                this.setJobExp(this.getJobExpToDown());
            } else {
                this.downLevel(this.getJobExp() - expDown);
            }
        }
    }
}

