/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.data.object;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.data.AbstractUser;
import su.nexmedia.engine.api.manager.IPlaceholder;
import su.nexmedia.engine.utils.EntityUtil;
import su.nexmedia.engine.utils.PDCUtil;
import su.nightexpress.moneyhunters.basic.Keys;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.MoneyHuntersAPI;
import su.nightexpress.moneyhunters.basic.api.booster.BoosterType;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.api.event.PlayerJobExpEvent;
import su.nightexpress.moneyhunters.basic.api.event.PlayerJobExpGainEvent;
import su.nightexpress.moneyhunters.basic.api.event.PlayerJobExpLoseEvent;
import su.nightexpress.moneyhunters.basic.api.event.PlayerJobLevelDownEvent;
import su.nightexpress.moneyhunters.basic.api.event.PlayerJobLevelUpEvent;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobState;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;
import su.nightexpress.moneyhunters.basic.manager.booster.BoosterManager;
import su.nightexpress.moneyhunters.basic.manager.booster.object.RankBooster;

public class MoneyUser
extends AbstractUser<MoneyHunters>
implements IPlaceholder {
    private final Map<String, UserJobData> jobData;
    private final Set<IBooster> boosters;

    public MoneyUser(@NotNull MoneyHunters plugin, @NotNull UUID uuid, @NotNull String name) {
        this(plugin, uuid, name, System.currentTimeMillis(), System.currentTimeMillis(), new HashMap<String, UserJobData>(), ConcurrentHashMap.newKeySet());
    }

    public MoneyUser(@NotNull MoneyHunters plugin, @NotNull UUID uuid, @NotNull String name, long dateCreated, long lastOnline, @NotNull Map<String, UserJobData> jobData, @NotNull Set<IBooster> boosters) {
        super((NexPlugin)plugin, uuid, name, dateCreated, lastOnline);
        this.jobData = jobData;
        this.boosters = ConcurrentHashMap.newKeySet();
        this.boosters.addAll(boosters);
        this.jobData.values().removeIf(Objects::isNull);
        MoneyHuntersAPI.getJobs().forEach(this::getJobData);
        this.updateBoosters();
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> str;
    }

    @NotNull
    public Map<String, UserJobData> getJobData() {
        return this.jobData;
    }

    @NotNull
    public UserJobData getJobData(@NotNull IJob<?> job) {
        return this.jobData.computeIfAbsent(job.getId(), job2 -> new UserJobData(job));
    }

    public int getJobsAmount(@NotNull JobState state) {
        return (int)this.getJobData().values().stream().filter(data -> data.getState() == state).count();
    }

    @NotNull
    public Collection<IBooster> getBoosters() {
        return this.boosters;
    }

    @NotNull
    public Collection<IBooster> getBoosters(@NotNull IJob<?> job) {
        return this.getBoosters().stream().filter(booster -> booster.isApplicable(job)).toList();
    }

    @NotNull
    public Collection<IBooster> getBoosters(@NotNull IJob<?> job, BoosterType type) {
        return this.getBoosters(job).stream().filter(booster -> booster.getType() == type).toList();
    }

    public double getBoosterExp(@NotNull IJob<?> job) {
        return BoosterManager.getBoosterExp(this.getBoosters(job));
    }

    public double getBoosterMoney(@NotNull IJob<?> job) {
        return BoosterManager.getBoosterMoney(this.getBoosters(job));
    }

    public void updateBoosters() {
        Player player = this.getPlayer();
        RankBooster rankBooster = player != null ? Config.getBoosterRank(player) : null;
        this.getBoosters().removeIf(boost -> boost == null || boost.isExpired());
        this.getBoosters().removeIf(boost -> boost.getType() != BoosterType.PERSONAL && boost.getType() != BoosterType.CUSTOM);
        this.getBoosters().addAll(((MoneyHunters)this.plugin).getBoosterManager().getBoostersAuto());
        this.getBoosters().addAll(((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal());
        if (rankBooster != null) {
            this.getBoosters().add(rankBooster);
        }
    }

    public void addJobLevel(@NotNull IJob<?> job, int amount) {
        if (!Config.LEVELING_ENABLED || amount == 0) {
            return;
        }
        UserJobData progress = this.getJobData(job);
        boolean isMinus = amount < 0;
        for (int count = 0; count < Math.abs(amount); ++count) {
            int exp = isMinus ? progress.getJobExpToDown() : progress.getJobExpToUp();
            this.addJobExp(job, exp, false);
        }
    }

    public void addJobExp(@NotNull IJob<?> job, double exp) {
        this.addJobExp(job, exp, false);
    }

    public void addJobExp(@NotNull IJob<?> job, double exp, boolean useBooster) {
        this.addJobExp(job, "", exp, useBooster);
    }

    public void addJobExp(@NotNull IJob<?> job, @NotNull String source, double exp, boolean useBooster) {
        int expAdd;
        boolean isLose;
        if (!Config.LEVELING_ENABLED) {
            return;
        }
        UserJobData jobData = this.getJobData(job);
        Player player = this.getPlayer();
        if (useBooster && exp > 0.0) {
            exp *= this.getBoosterExp(job);
        }
        boolean bl = isLose = (expAdd = (int)exp) < 0;
        if (player != null) {
            PlayerJobExpEvent event = isLose ? new PlayerJobExpLoseEvent(player, this, jobData, source, expAdd) : new PlayerJobExpGainEvent(player, this, jobData, source, expAdd);
            ((MoneyHunters)this.plugin).getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            expAdd = event.getExp();
        }
        int levelHas = jobData.getJobLevel();
        if (isLose) {
            jobData.takeExp(expAdd);
        } else {
            jobData.addExp(expAdd);
        }
        if (player != null) {
            (isLose ? ((MoneyHunters)this.plugin).getMessage(Lang.JOBS_LEVELING_EXP_LOSE) : ((MoneyHunters)this.plugin).getMessage(Lang.JOBS_LEVELING_EXP_GAIN)).replace(jobData.replacePlaceholders()).replace("%exp%", (Object)expAdd).send((CommandSender)player);
            IMoneyObjective objective = job.getObjective(source);
            if (objective != null) {
                ((MoneyHunters)this.plugin).getJobManager().countObjective(player, isLose ? -expAdd : expAdd, job, objective, ObjectiveLimitType.EXP);
            }
            if (levelHas > jobData.getJobLevel()) {
                PlayerJobLevelDownEvent levelDownEvent = new PlayerJobLevelDownEvent(player, this, jobData);
                ((MoneyHunters)this.plugin).getPluginManager().callEvent((Event)levelDownEvent);
                ((MoneyHunters)this.plugin).getMessage(Lang.JOBS_LEVELING_LEVEL_DOWN).replace(jobData.replacePlaceholders()).send((CommandSender)player);
            } else if (levelHas < jobData.getJobLevel()) {
                PlayerJobLevelUpEvent levelUpEvent = new PlayerJobLevelUpEvent(player, this, jobData);
                ((MoneyHunters)this.plugin).getPluginManager().callEvent((Event)levelUpEvent);
                ((MoneyHunters)this.plugin).getMessage(Lang.JOBS_LEVELING_LEVEL_UP).replace(jobData.replacePlaceholders()).send((CommandSender)player);
                if (Config.LEVELING_LEVEUP_FIREWORK) {
                    Firework firework = EntityUtil.spawnRandomFirework((Location)player.getLocation());
                    PDCUtil.setData((PersistentDataHolder)firework, (NamespacedKey)Keys.JOB_FIREWORK, (Object)true);
                }
            }
        }
    }
}

