/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.data;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.data.AbstractUserDataHandler;
import su.nexmedia.engine.api.data.DataTypes;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.booster.BoosterType;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;
import su.nightexpress.moneyhunters.basic.data.serialize.JobDataSerializer;
import su.nightexpress.moneyhunters.basic.data.serialize.PersonalBoosterSerializer;
import su.nightexpress.moneyhunters.basic.manager.booster.object.PersonalBooster;

public class MoneyDataHandler
extends AbstractUserDataHandler<MoneyHunters, MoneyUser> {
    private static MoneyDataHandler instance;
    private final Function<ResultSet, MoneyUser> userFunction = resultSet -> {
        try {
            UUID uuid = UUID.fromString(resultSet.getString("uuid"));
            String name = resultSet.getString("name");
            long dateCreated = resultSet.getLong("dateCreated");
            long lastOnline = resultSet.getLong("last_online");
            HashMap<String, UserJobData> jobData = new HashMap();
            if (Config.LEVELING_ENABLED) {
                jobData = (Map)this.gson.fromJson(resultSet.getString("progress"), new TypeToken<Map<String, UserJobData>>(){}.getType());
            }
            Set boosters = (Set)this.gson.fromJson(resultSet.getString("boosters"), new TypeToken<Set<PersonalBooster>>(){}.getType());
            return new MoneyUser(plugin, uuid, name, dateCreated, lastOnline, jobData, boosters);
        }
        catch (SQLException ex) {
            return null;
        }
    };

    protected MoneyDataHandler(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, (UserDataHolder)plugin);
    }

    public static MoneyDataHandler getInstance(@NotNull MoneyHunters plugin) throws SQLException {
        if (instance == null) {
            instance = new MoneyDataHandler(plugin);
        }
        return instance;
    }

    protected void onShutdown() {
        super.onShutdown();
        instance = null;
    }

    public void onSynchronize() {
    }

    @NotNull
    protected GsonBuilder registerAdapters(@NotNull GsonBuilder builder) {
        return super.registerAdapters(builder.registerTypeAdapter(UserJobData.class, (Object)new JobDataSerializer()).registerTypeAdapter(PersonalBooster.class, (Object)new PersonalBoosterSerializer()));
    }

    protected void onTableCreate() {
        this.addColumn(this.tableUsers, "boosters", DataTypes.STRING.build(this.getDataType()), "[]");
        super.onTableCreate();
    }

    @NotNull
    protected LinkedHashMap<String, String> getColumnsToCreate() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("progress", DataTypes.STRING.build(this.getDataType()));
        map.put("boosters", DataTypes.STRING.build(this.getDataType()));
        return map;
    }

    @NotNull
    protected LinkedHashMap<String, String> getColumnsToSave(@NotNull MoneyUser user) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("progress", this.gson.toJson(user.getJobData()));
        map.put("boosters", this.gson.toJson(user.getBoosters().stream().filter(booster -> booster.getType() == BoosterType.PERSONAL && !booster.isExpired()).toList()));
        return map;
    }

    @NotNull
    protected Function<ResultSet, MoneyUser> getFunctionToUser() {
        return this.userFunction;
    }
}

