/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.config;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.hooks.Hooks;
import su.nexmedia.engine.hooks.external.VaultHook;
import su.nexmedia.engine.hooks.external.WorldGuardHook;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.booster.AbstractBooster;
import su.nightexpress.moneyhunters.basic.manager.booster.object.AutoBooster;
import su.nightexpress.moneyhunters.basic.manager.booster.object.RankBooster;

public class Config {
    public static Set<String> GEN_GLITCH_IGNORE_SPAWN_REASONS;
    public static Set<String> GEN_GLITCH_IGNORE_GAME_MODES;
    public static Set<String> GEN_GLITCH_IGNORE_BLOCK_GENERATORS;
    public static Set<String> GEN_DISABLED_WORLDS;
    public static boolean GEN_HOOKS_DISABLED_ON_MOB_ARENA;
    public static Set<String> GEN_HOOKS_DISABLED_WG_REGIONS;
    public static boolean LEVELING_ENABLED;
    public static boolean LEVELING_LEVEUP_FIREWORK;
    public static int BOOSTERS_UPDATE_INTERVAL;
    public static boolean BOOSTERS_NOTIFY_ON_JOIN;
    public static int BOOSTERS_NOTIFY_INTERVAL;
    private static Set<AutoBooster> BOOSTERS_AUTO;
    private static Set<RankBooster> BOOSTERS_RANK;
    public static boolean MONEY_OWNER_PROTECTION_ENABLED;
    public static boolean MONEY_MERGING_ENABLED;
    public static long MONEY_FULL_INVENTORY_TASK_INTERVAL;

    public static void load(@NotNull MoneyHunters plugin) {
        AbstractBooster boost;
        double bMultMoney;
        double bMultExp;
        Set bJobs;
        String path2;
        JYML cfg = plugin.getConfig();
        String path = "Generic.Glitches.";
        cfg.addMissing(path + "Ignore_Block_Generators", Arrays.asList("STONE", "COBBLESTONE", "OBSIDIAN"));
        GEN_GLITCH_IGNORE_SPAWN_REASONS = cfg.getStringSet(path + "Ignore_Spawn_Reasons").stream().map(String::toUpperCase).collect(Collectors.toSet());
        GEN_GLITCH_IGNORE_GAME_MODES = cfg.getStringSet(path + "Ignore_Game_Modes").stream().map(String::toUpperCase).collect(Collectors.toSet());
        GEN_GLITCH_IGNORE_BLOCK_GENERATORS = cfg.getStringSet(path + "Ignore_Block_Generators").stream().map(String::toUpperCase).collect(Collectors.toSet());
        path = "Generic.";
        GEN_DISABLED_WORLDS = cfg.getStringSet(path + "Disabled_Worlds");
        path = "Generic.Hooks.";
        boolean bl = GEN_HOOKS_DISABLED_ON_MOB_ARENA = cfg.getBoolean(path + "Disabled_In_AdvancedMobArena") && Hooks.hasPlugin((String)"AdvancedMobArena");
        if (Hooks.hasPlugin((String)"WorldGuard")) {
            GEN_HOOKS_DISABLED_WG_REGIONS = cfg.getStringSet(path + "Disabled_WorldGuard_Regions").stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        if (LEVELING_ENABLED = cfg.getBoolean((path = "Leveling.") + "Enabled")) {
            LEVELING_LEVEUP_FIREWORK = cfg.getBoolean(path + "Level_Up.Firework");
        }
        path = "Boosters.";
        cfg.addMissing(path + "Update_Interval", (Object)60);
        cfg.addMissing(path + "Notify.On_Join", (Object)true);
        cfg.addMissing(path + "Notify.Interval", (Object)900);
        BOOSTERS_UPDATE_INTERVAL = cfg.getInt(path + "Update_Interval", 60);
        BOOSTERS_NOTIFY_ON_JOIN = cfg.getBoolean(path + "Notify.On_Join");
        BOOSTERS_NOTIFY_INTERVAL = cfg.getInt(path + "Notify.Interval", 900);
        BOOSTERS_AUTO = new HashSet<AutoBooster>();
        BOOSTERS_RANK = new HashSet<RankBooster>();
        for (String bId : cfg.getSection(path + "Global")) {
            path2 = path + "Global." + bId + ".";
            Set<DayOfWeek> bDays = AutoBooster.parseDays(cfg.getString(path2 + "Times.Days", ""));
            Set<LocalTime[]> bTimes = AutoBooster.parseTimes(cfg.getStringList(path2 + "Times.Times"));
            bJobs = cfg.getStringSet(path2 + "Jobs");
            bMultExp = cfg.getDouble(path2 + "Multiplier.Exp", 1.0);
            bMultMoney = cfg.getDouble(path2 + "Multiplier.Money", 1.0);
            boost = new AutoBooster(bDays, bTimes, bJobs, bMultMoney, bMultExp);
            BOOSTERS_AUTO.add((AutoBooster)boost);
        }
        for (String bId : cfg.getSection(path + "Rank")) {
            path2 = path + "Rank." + bId + ".";
            int priority = cfg.getInt(path2 + "Priority");
            String rank = cfg.getString(path2 + "Rank", "");
            if (rank.isEmpty()) continue;
            bJobs = cfg.getStringSet(path2 + "Jobs");
            bMultExp = cfg.getDouble(path2 + "Multiplier.Exp", 1.0);
            bMultMoney = cfg.getDouble(path2 + "Multiplier.Money", 1.0);
            boost = new RankBooster(bJobs, bMultMoney, bMultExp, priority, rank);
            BOOSTERS_RANK.add((RankBooster)boost);
        }
        path = "Money.Owner_Protection.";
        MONEY_OWNER_PROTECTION_ENABLED = cfg.getBoolean(path + "Enabled");
        path = "Money.Merging.";
        MONEY_MERGING_ENABLED = cfg.getBoolean(path + "Enabled");
        path = "Money.Full_Inventory.";
        if (cfg.getBoolean(path + "Enable_Bypass")) {
            MONEY_FULL_INVENTORY_TASK_INTERVAL = cfg.getInt(path + "Task_Tick_Interval", 40);
        }
    }

    public static boolean isDisabledRegion(@NotNull Player player) {
        if (!Hooks.hasWorldGuard()) {
            return false;
        }
        return GEN_HOOKS_DISABLED_WG_REGIONS.contains(WorldGuardHook.getRegion((Entity)player));
    }

    @NotNull
    public static Collection<AutoBooster> getBoosters() {
        return BOOSTERS_AUTO;
    }

    @Nullable
    public static RankBooster getBoosterRank(@NotNull Player player) {
        return BOOSTERS_RANK.stream().filter(booster -> VaultHook.getPermissionGroups((Player)player).contains(booster.getRank())).max(Comparator.comparingInt(RankBooster::getPriority)).orElse(null);
    }

    static {
        MONEY_FULL_INVENTORY_TASK_INTERVAL = 0L;
    }
}

